/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.constraint;

import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class MinLength
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected final int min;

    public MinLength(int min) {
        MinLength.checkPreconditions(min);
        this.min = min;
    }

    public MinLength(int min, CellProcessor next) {
        super(next);
        MinLength.checkPreconditions(min);
        this.min = min;
    }

    private static void checkPreconditions(int min) {
        if (min < 0) {
            throw new IllegalArgumentException(String.format("min (%d) should not be >= 0", min));
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        String stringValue = value.toString();
        int length = stringValue.length();
        if (length < this.min) {
            throw new SuperCsvConstraintViolationException(String.format("the length (%d) of value '%s' does not lie the min (%d) values (inclusive)", length, stringValue, this.min), context, (CellProcessor)this);
        }
        return this.next.execute((Object)stringValue, context);
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("min", this.getMin());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

