/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.constraint;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.ext.util.DateFormatWrapper;
import org.supercsv.util.CsvContext;

public class FutureDate<T extends Date>
extends CellProcessorAdaptor
implements DateCellProcessor,
ValidationCellProcessor {
    protected final T min;
    protected DateFormat formatter;

    public FutureDate(T min) {
        FutureDate.checkPreconditions(min);
        this.min = min;
    }

    public FutureDate(T min, CellProcessor next) {
        super(next);
        FutureDate.checkPreconditions(min);
        this.min = min;
    }

    protected static <T extends Date> void checkPreconditions(T min) {
        if (min == null) {
            throw new NullPointerException("min should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!Date.class.isAssignableFrom(value.getClass())) {
            throw new SuperCsvConstraintViolationException(String.format("the value '%s' could not implement '%s' class.", value, Date.class.getCanonicalName()), context, (CellProcessor)this);
        }
        Date result = (Date)value;
        if (result.compareTo((Date)this.min) < 0) {
            throw new SuperCsvConstraintViolationException(String.format("%s does not lie the min (%s) values (inclusive)", result, this.min), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    public T getMin() {
        return this.min;
    }

    public DateFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DateFormat formatter) {
        this.formatter = formatter;
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, T> vars = new HashMap<String, T>();
        vars.put("min", this.getMin());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            DateFormatWrapper df = this.getFormatter() != null ? new DateFormatWrapper(this.getFormatter()) : new DateFormatWrapper(date.getClass());
            return df.format(date);
        }
        return value.toString();
    }
}

