/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.ext.util.ConversionException;
import org.supercsv.ext.util.NumberFormatWrapper;
import org.supercsv.util.CsvContext;

public class ParseLocaleNumber<N extends Number>
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    private final Class<N> type;
    protected final NumberFormatWrapper formatter;

    public ParseLocaleNumber(Class<N> type, NumberFormat formatter, boolean lenient) {
        ParseLocaleNumber.checkPreconditions(type, formatter);
        this.type = type;
        this.formatter = new NumberFormatWrapper(formatter, lenient);
    }

    public ParseLocaleNumber(Class<N> type, NumberFormat formatter, boolean lenient, CellProcessor next) {
        super(next);
        ParseLocaleNumber.checkPreconditions(type, formatter);
        this.type = type;
        this.formatter = new NumberFormatWrapper(formatter, lenient);
    }

    public ParseLocaleNumber(Class<N> type, NumberFormat formatter) {
        this(type, formatter, false);
    }

    public ParseLocaleNumber(Class<N> type, NumberFormat formatter, CellProcessor next) {
        this(type, formatter, false, next);
    }

    private static <N extends Number> void checkPreconditions(Class<N> type, NumberFormat formatter) {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        try {
            N result = this.formatter.parse(this.type, (String)value);
            return this.next.execute(result, context);
        }
        catch (ParseException | ConversionException e) {
            throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as a BigDecimal", value), context, (CellProcessor)this, (Throwable)e);
        }
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("type", this.getType().getCanonicalName());
        vars.put("pattern", this.getPattern());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return this.formatter.format(number);
        }
        return value.toString();
    }

    public Class<N> getType() {
        return this.type;
    }

    public String getPattern() {
        return this.formatter.getPattern();
    }
}

