/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.ext.util.DateFormatWrapper;
import org.supercsv.util.CsvContext;

public class ParseLocaleDate
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected final DateFormatWrapper formatter;

    public ParseLocaleDate(DateFormat formatter) {
        ParseLocaleDate.checkPreconditions(formatter);
        this.formatter = new DateFormatWrapper(formatter);
    }

    public ParseLocaleDate(DateFormat formatter, DateCellProcessor next) {
        super((CellProcessor)next);
        ParseLocaleDate.checkPreconditions(formatter);
        this.formatter = new DateFormatWrapper(formatter);
    }

    private static void checkPreconditions(DateFormat formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        try {
            Date result = this.parse((String)value);
            return this.next.execute((Object)result, context);
        }
        catch (ParseException e) {
            throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as a Date", value), context, (CellProcessor)this, (Throwable)e);
        }
    }

    protected Date parse(String value) throws ParseException {
        return this.formatter.parse(value);
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("pattern", this.formatter.getPattern());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return this.formatter.format(date);
        }
        return value.toString();
    }

    public String getPattern() {
        return this.formatter.getPattern();
    }
}

