/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class FormatEnum
extends CellProcessorAdaptor
implements ValidationCellProcessor {
    protected final Class<? extends Enum<?>> type;
    protected final Map<Enum<?>, String> enumValueMap;
    protected final Method valueMethod;

    public <T extends Enum<T>> FormatEnum(Class<T> type) {
        FormatEnum.checkPreconditions(type);
        this.type = type;
        this.enumValueMap = this.createEnumMap(type);
        this.valueMethod = null;
    }

    public <T extends Enum<T>> FormatEnum(Class<T> type, StringCellProcessor next) {
        super((CellProcessor)next);
        FormatEnum.checkPreconditions(type);
        this.type = type;
        this.enumValueMap = this.createEnumMap(type);
        this.valueMethod = null;
    }

    public <T extends Enum<T>> FormatEnum(Class<T> type, String valueMethodName) {
        FormatEnum.checkPreconditions(type);
        this.type = type;
        this.enumValueMap = this.createEnumMap(type, valueMethodName);
        this.valueMethod = this.getEnumValueMethod(type, valueMethodName);
    }

    public <T extends Enum<T>> FormatEnum(Class<T> type, String valueMethodName, StringCellProcessor next) {
        super((CellProcessor)next);
        FormatEnum.checkPreconditions(type);
        this.type = type;
        this.enumValueMap = this.createEnumMap(type, valueMethodName);
        this.valueMethod = this.getEnumValueMethod(type, valueMethodName);
    }

    protected static void checkPreconditions(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type should be not null");
        }
    }

    protected <T extends Enum<?>> Method getEnumValueMethod(Class<T> enumClass, String valueMethodName) {
        try {
            Method method = enumClass.getMethod(valueMethodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("not found method '%s'", valueMethodName), e);
        }
    }

    protected <T extends Enum<T>> Map<Enum<?>, String> createEnumMap(Class<T> enumClass) {
        EnumSet<Enum> set = EnumSet.allOf(enumClass);
        LinkedHashMap<Enum, String> map = new LinkedHashMap<Enum, String>();
        for (Enum e : set) {
            map.put(e, e.name());
        }
        return Collections.unmodifiableMap(map);
    }

    protected <T extends Enum<T>> Map<Enum<?>, String> createEnumMap(Class<T> enumClass, String methodName) {
        Method method = this.getEnumValueMethod(enumClass, methodName);
        LinkedHashMap<Enum, String> map = new LinkedHashMap<Enum, String>();
        try {
            EnumSet<Enum> set = EnumSet.allOf(enumClass);
            for (Enum e : set) {
                Object returnValue = method.invoke((Object)e, new Object[0]);
                map.put(e, returnValue.toString());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("fail get enum value.", e);
        }
        return Collections.unmodifiableMap(map);
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!value.getClass().isAssignableFrom(this.type)) {
            throw new SuperCsvCellProcessorException(this.type, value, context, (CellProcessor)this);
        }
        String result = this.getEnumValueMap().get((Enum)value);
        return this.next.execute((Object)result, context);
    }

    public Class<?> getType() {
        return this.type;
    }

    public Map<Enum<?>, String> getEnumValueMap() {
        return this.enumValueMap;
    }

    public Method getValueMethod() {
        return this.valueMethod;
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("type", this.getType().getCanonicalName());
        vars.put("valueMethod", this.getValueMethod() == null ? "" : this.getValueMethod().getName());
        List enumValues = this.getEnumValueMap().entrySet().stream().map(e -> (Enum)e.getKey()).collect(Collectors.toList());
        String enumsStr = this.getEnumValueMap().entrySet().stream().map(e -> (String)e.getValue()).collect(Collectors.joining(", "));
        vars.put("enumValues", enumValues);
        vars.put("enumsStr", enumsStr);
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isAssignableFrom(this.type)) {
            Enum enumValue = (Enum)value;
            return this.getEnumValueMap().get(enumValue);
        }
        return value.toString();
    }
}

