/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.time;

import java.lang.annotation.Annotation;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.time.FmtZonedDateTime;
import org.supercsv.cellprocessor.time.ParseZonedDateTime;
import org.supercsv.ext.annotation.CsvDateConverter;
import org.supercsv.ext.builder.time.AbstractTemporalAccessorCellProcessorBuilder;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class ZonedDateTimeCellProcessorBuilder
extends AbstractTemporalAccessorCellProcessorBuilder<ZonedDateTime> {
    @Override
    protected String getDefaultPattern() {
        return "uuuu-MM-dd HH:mm:ssxxx'['VV']'";
    }

    @Override
    public Optional<ZonedDateTime> parseValue(Class<ZonedDateTime> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        String pattern = this.getPattern(converterAnno);
        try {
            return Optional.of(ZonedDateTime.parse(strValue, formatter));
        }
        catch (DateTimeParseException e) {
            throw new SuperCsvInvalidAnnotationException(String.format("default '%s' value cannot parse to ZonedDateTime with pattern '%s'", strValue, pattern), e);
        }
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<ZonedDateTime> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        Optional<ZonedDateTime> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<ZonedDateTime> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        CellProcessor cp = processor;
        FmtZonedDateTime fmtZonedDateTime = cp = cp == null ? new FmtZonedDateTime(formatter) : new FmtZonedDateTime(formatter, cp);
        if (!ignoreValidationProcessor) {
            cp = this.prependRangeProcessor(type, annos, cp, min, max);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<ZonedDateTime> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        Optional<ZonedDateTime> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<ZonedDateTime> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        CellProcessor cp = processor;
        cp = (cp = this.prependRangeProcessor(type, annos, cp, min, max)) == null ? new ParseZonedDateTime(formatter) : new ParseZonedDateTime(formatter, cp);
        return cp;
    }
}

