/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.time;

import java.lang.annotation.Annotation;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.ext.annotation.CsvDateConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.time.FutureTemporal;
import org.supercsv.ext.cellprocessor.time.PastTemporal;
import org.supercsv.ext.cellprocessor.time.TemporalRange;
import org.supercsv.ext.util.Utils;

public abstract class AbstractTemporalAccessorCellProcessorBuilder<T extends TemporalAccessor & Comparable<? super T>>
extends AbstractCellProcessorBuilder<T> {
    protected Optional<CsvDateConverter> getDateConverterAnnotation(Annotation[] annos) {
        return AbstractTemporalAccessorCellProcessorBuilder.getAnnotation(annos, CsvDateConverter.class);
    }

    protected String getPattern(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.pattern()).filter(s -> s.length() > 0).orElse(this.getDefaultPattern());
    }

    protected ResolverStyle getResolverStyle(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.lenient() ? ResolverStyle.LENIENT : ResolverStyle.STRICT).orElse(ResolverStyle.LENIENT);
    }

    protected Locale getLocale(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> Utils.getLocale(a.locale())).orElse(Locale.getDefault());
    }

    protected ZoneId getZoneId(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.timezone()).filter(s -> s.length() > 0).map(s -> TimeZone.getTimeZone(s).toZoneId()).orElse(ZoneId.systemDefault());
    }

    protected Optional<String> getMin(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.min()).filter(s -> s.length() > 0);
    }

    protected Optional<String> getMax(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.max()).filter(s -> s.length() > 0);
    }

    protected CellProcessor prependRangeProcessor(Class<T> type, Annotation[] annos, CellProcessor cellProcessor, Optional<T> min, Optional<T> max) {
        DateTimeFormatter formatter = this.createDateTimeFormatter(this.getDateConverterAnnotation(annos));
        if (min.isPresent() && max.isPresent()) {
            TemporalRange<TemporalAccessor> cp = cellProcessor == null ? new TemporalRange<TemporalAccessor>((TemporalAccessor)min.get(), (TemporalAccessor)max.get()) : new TemporalRange<TemporalAccessor>((TemporalAccessor)min.get(), (TemporalAccessor)max.get(), cellProcessor);
            cp.setFormatter(formatter);
            return cp;
        }
        if (min.isPresent()) {
            FutureTemporal<TemporalAccessor> cp = cellProcessor == null ? new FutureTemporal<TemporalAccessor>((TemporalAccessor)min.get()) : new FutureTemporal<TemporalAccessor>((TemporalAccessor)min.get(), cellProcessor);
            cp.setFormatter(formatter);
            return cp;
        }
        if (max.isPresent()) {
            PastTemporal<TemporalAccessor> cp = cellProcessor == null ? new PastTemporal<TemporalAccessor>((TemporalAccessor)max.get()) : new PastTemporal<TemporalAccessor>((TemporalAccessor)max.get(), cellProcessor);
            cp.setFormatter(formatter);
            return cp;
        }
        return cellProcessor;
    }

    protected abstract String getDefaultPattern();

    protected DateTimeFormatter createDateTimeFormatter(Optional<CsvDateConverter> converterAnno) {
        String pattern = this.getPattern(converterAnno);
        ResolverStyle style = this.getResolverStyle(converterAnno);
        Locale locale = this.getLocale(converterAnno);
        ZoneId zone = this.getZoneId(converterAnno);
        return DateTimeFormatter.ofPattern(pattern, locale).withResolverStyle(style).withZone(zone);
    }
}

