/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.joda;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.joda.FmtLocalTime;
import org.supercsv.cellprocessor.joda.ParseLocalTime;
import org.supercsv.ext.annotation.CsvDateConverter;
import org.supercsv.ext.builder.joda.AbstractJodaCellProcessorBuilder;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class LocalTimeCellProcessorBuilder
extends AbstractJodaCellProcessorBuilder<LocalTime> {
    @Override
    protected String getDefaultPattern() {
        return "HH:mm:ss";
    }

    @Override
    public Optional<LocalTime> parseValue(Class<LocalTime> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        String pattern = this.getPattern(converterAnno);
        try {
            return Optional.of(LocalTime.parse((String)strValue, (DateTimeFormatter)formatter));
        }
        catch (IllegalArgumentException e) {
            throw new SuperCsvInvalidAnnotationException(String.format("default '%s' value cannot parse to LocalTime with pattern '%s'", strValue, pattern), e);
        }
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<LocalTime> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        Optional<LocalTime> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<LocalTime> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        CellProcessor cp = processor;
        FmtLocalTime fmtLocalTime = cp = cp == null ? new FmtLocalTime(formatter) : new FmtLocalTime(formatter, cp);
        if (!ignoreValidationProcessor) {
            cp = this.prependRangeProcessor(type, annos, cp, min, max);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<LocalTime> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        Optional<LocalTime> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<LocalTime> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        CellProcessor cp = processor;
        cp = (cp = this.prependRangeProcessor(type, annos, cp, min, max)) == null ? new ParseLocalTime(formatter) : new ParseLocalTime(formatter, cp);
        return cp;
    }
}

