/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.joda;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.joda.time.Duration;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.joda.FmtDuration;
import org.supercsv.cellprocessor.joda.ParseDuration;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class DurationCellProcessorBuilder
extends AbstractCellProcessorBuilder<Duration> {
    @Override
    public CellProcessor buildOutputCellProcessor(Class<Duration> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        CellProcessor cp = processor;
        cp = cp == null ? new FmtDuration() : new FmtDuration(cp);
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<Duration> type, Annotation[] annos, CellProcessor processor) {
        CellProcessor cp = processor;
        cp = cp == null ? new ParseDuration() : new ParseDuration(cp);
        return cp;
    }

    @Override
    public Optional<Duration> parseValue(Class<Duration> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Duration.parse((String)strValue));
        }
        catch (IllegalArgumentException e) {
            throw new SuperCsvInvalidAnnotationException(String.format("default '%s' value cannot parse to Duration.", strValue), e);
        }
    }
}

