/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.impl;

import java.lang.annotation.Annotation;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvDateConverter;
import org.supercsv.ext.builder.impl.AbstractDateCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.FormatLocaleDate;
import org.supercsv.ext.cellprocessor.ParseLocaleSqlDate;

public class SqlDateCellProcessorBuilder
extends AbstractDateCellProcessorBuilder<Date> {
    @Override
    public String getDefaultPattern() {
        return "yyyy-MM-dd";
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<Date> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateFormat formatter = this.createDateFormatter(converterAnno);
        Optional<Date> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<Date> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Object cp = processor;
        FormatLocaleDate formatLocaleDate = cp = cp == null ? new FormatLocaleDate(formatter) : new FormatLocaleDate(formatter, (StringCellProcessor)cp);
        if (!ignoreValidationProcessor) {
            cp = this.prependRangeProcessor(type, annos, (CellProcessor)cp, min, max);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<Date> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateFormat formatter = this.createDateFormatter(converterAnno);
        Optional<Date> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<Date> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Object cp = processor;
        cp = (cp = this.prependRangeProcessor(type, annos, (CellProcessor)cp, min, max)) == null ? new ParseLocaleSqlDate(formatter) : new ParseLocaleSqlDate(formatter, (DateCellProcessor)cp);
        return cp;
    }

    @Override
    public Optional<Date> parseValue(Class<Date> type, Annotation[] annos, String strValue) {
        return this.parseDate(annos, strValue).map(d -> new Date(d.getTime()));
    }
}

