/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvEnumConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.FormatEnum;
import org.supercsv.ext.cellprocessor.ParseEnum;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class EnumCellProcessorBuilder<T extends Enum<T>>
extends AbstractCellProcessorBuilder<T> {
    protected Optional<CsvEnumConverter> getEnumConverterAnnotation(Annotation[] annos) {
        return EnumCellProcessorBuilder.getAnnotation(annos, CsvEnumConverter.class);
    }

    protected boolean getIgnoreCase(Optional<CsvEnumConverter> converterAnno) {
        return converterAnno.map(a -> a.ignoreCase()).orElse(false);
    }

    protected Optional<String> getValueMethodName(Optional<CsvEnumConverter> converterAnno) {
        return converterAnno.map(a -> a.valueMethodName()).filter(s -> s.length() > 0);
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<T> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvEnumConverter> converterAnno = this.getEnumConverterAnnotation(annos);
        Optional<String> valueMethodName = this.getValueMethodName(converterAnno);
        Object cp = processor;
        if (valueMethodName.isPresent()) {
            cp = cp == null ? new FormatEnum(type, valueMethodName.get()) : new FormatEnum(type, valueMethodName.get(), (StringCellProcessor)cp);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<T> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvEnumConverter> converterAnno = this.getEnumConverterAnnotation(annos);
        boolean ignoreCase = this.getIgnoreCase(converterAnno);
        Optional<String> valueMethodName = this.getValueMethodName(converterAnno);
        Object cp = processor;
        cp = valueMethodName.isPresent() ? (cp == null ? new ParseEnum(type, ignoreCase, valueMethodName.get()) : new ParseEnum(type, ignoreCase, valueMethodName.get(), (CellProcessor)cp)) : (cp == null ? new ParseEnum(type, ignoreCase) : new ParseEnum(type, ignoreCase, (CellProcessor)cp));
        return cp;
    }

    @Override
    public Optional<T> parseValue(Class<T> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        Optional<CsvEnumConverter> converterAnno = this.getEnumConverterAnnotation(annos);
        boolean ignoreCase = this.getIgnoreCase(converterAnno);
        Optional<String> valueMethodName = this.getValueMethodName(converterAnno);
        EnumSet<Enum> set = EnumSet.allOf(type);
        if (valueMethodName.isPresent()) {
            try {
                Method valueMethod = type.getMethod(valueMethodName.get(), new Class[0]);
                valueMethod.setAccessible(true);
                for (Enum e : set) {
                    String value = valueMethod.invoke((Object)e, new Object[0]).toString();
                    if (strValue.equals(value)) {
                        return Optional.of(e);
                    }
                    if (!ignoreCase || !strValue.equalsIgnoreCase(value)) continue;
                    return Optional.of(e);
                }
            }
            catch (ReflectiveOperationException e) {
                throw new SuperCsvInvalidAnnotationException(String.format("enum class '%s' has not method '%s'", type.getCanonicalName(), valueMethodName));
            }
        } else {
            for (Enum e : set) {
                if (strValue.equals(e.name())) {
                    return Optional.of(e);
                }
                if (!ignoreCase || !strValue.equalsIgnoreCase(e.name())) continue;
                return Optional.of(e);
            }
        }
        throw new SuperCsvInvalidAnnotationException(String.format("parse fail enum value %s", strValue));
    }
}

