/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.impl;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Optional;
import org.supercsv.cellprocessor.ParseBigDecimal;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvNumberConverter;
import org.supercsv.ext.builder.impl.AbstractNumberCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.FormatLocaleNumber;
import org.supercsv.ext.cellprocessor.ParseLocaleNumber;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;

public class BigDecimalCellProcessorBuilder
extends AbstractNumberCellProcessorBuilder<BigDecimal> {
    @Override
    public CellProcessor buildOutputCellProcessor(Class<BigDecimal> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvNumberConverter> converterAnno = this.getNumberConverterAnnotation(annos);
        Optional<NumberFormat> formatter = this.createNumberFormatter(converterAnno);
        Optional<BigDecimal> min = this.getMin(converterAnno).map(n -> this.parseValue(type, annos, (String)n).get());
        Optional<BigDecimal> max = this.getMax(converterAnno).map(n -> this.parseValue(type, annos, (String)n).get());
        Object cp = processor;
        if (formatter.isPresent()) {
            FormatLocaleNumber formatLocaleNumber = cp = cp == null ? new FormatLocaleNumber(formatter.get()) : new FormatLocaleNumber(formatter.get(), (StringCellProcessor)cp);
        }
        if (!ignoreValidationProcessor) {
            cp = this.prependRangeProcessor(type, annos, (CellProcessor)cp, min, max);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<BigDecimal> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvNumberConverter> converterAnno = this.getNumberConverterAnnotation(annos);
        Optional<NumberFormat> formatter = this.createNumberFormatter(converterAnno);
        boolean lenient = this.getLenient(converterAnno);
        Optional<BigDecimal> min = this.getMin(converterAnno).map(n -> this.parseValue(type, annos, (String)n).get());
        Optional<BigDecimal> max = this.getMax(converterAnno).map(n -> this.parseValue(type, annos, (String)n).get());
        Object cp = processor;
        cp = this.prependRangeProcessor(type, annos, (CellProcessor)cp, min, max);
        cp = formatter.isPresent() ? (cp == null ? new ParseLocaleNumber<BigDecimal>(type, formatter.get(), lenient) : new ParseLocaleNumber<BigDecimal>(type, formatter.get(), lenient, (CellProcessor)cp)) : (cp == null ? new ParseBigDecimal() : new ParseBigDecimal(cp));
        return cp;
    }

    @Override
    public Optional<BigDecimal> parseValue(Class<BigDecimal> type, Annotation[] annos, String strValue) {
        if (strValue.isEmpty()) {
            return Optional.empty();
        }
        Optional<CsvNumberConverter> converterAnno = this.getNumberConverterAnnotation(annos);
        Optional<NumberFormat> formatter = this.createNumberFormatter(converterAnno);
        Optional<String> pattern = this.getPattern(converterAnno);
        if (formatter.isPresent()) {
            try {
                BigDecimal value = (BigDecimal)formatter.get().parse(strValue);
                return Optional.of(value);
            }
            catch (ParseException e) {
                throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to Number with pattern '%s'", strValue, pattern), e);
            }
        }
        return Optional.of(new BigDecimal(strValue));
    }
}

