/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.supercsv.ext.builder.CellProcessorBuilder;
import org.supercsv.ext.builder.impl.BigDecimalCellProcessorBuilder;
import org.supercsv.ext.builder.impl.BigIntegerCellProcessorBuilder;
import org.supercsv.ext.builder.impl.BooleanCellProcessorBuilder;
import org.supercsv.ext.builder.impl.ByteCellProcessorBuilder;
import org.supercsv.ext.builder.impl.CharacterCellProcessorBuilder;
import org.supercsv.ext.builder.impl.DateCellProcessorBuilder;
import org.supercsv.ext.builder.impl.DoubleCellProcessorBuilder;
import org.supercsv.ext.builder.impl.EnumCellProcessorBuilder;
import org.supercsv.ext.builder.impl.FloatCellProcessorBuilder;
import org.supercsv.ext.builder.impl.IntegerCellProcessorBuilder;
import org.supercsv.ext.builder.impl.LongCellProcessorBuilder;
import org.supercsv.ext.builder.impl.ShortCellProcessorBuilder;
import org.supercsv.ext.builder.impl.SqlDateCellProcessorBuilder;
import org.supercsv.ext.builder.impl.StringCellProcessorBuilder;
import org.supercsv.ext.builder.impl.TimeCellProcessorBuilder;
import org.supercsv.ext.builder.impl.TimestampCellProcessorBuilder;
import org.supercsv.ext.builder.joda.DateTimeZoneCellProcessorBuilder;
import org.supercsv.ext.builder.joda.DurationCellProcessorBuilder;
import org.supercsv.ext.builder.joda.IntervalCellProcessorBuilder;
import org.supercsv.ext.builder.joda.LocalDateTimeCellProcessorBuilder;
import org.supercsv.ext.builder.joda.LocalTimeCellProcessorBuilder;
import org.supercsv.ext.builder.time.LocalDateCellProcessorBuilder;
import org.supercsv.ext.builder.time.PeriodCellProcessorBuilder;
import org.supercsv.ext.builder.time.ZoneIdCellProcessorBuilder;
import org.supercsv.ext.builder.time.ZonedDateTimeCellProcessorBuilder;

public class CellProcessorBuilderContainer {
    private final Map<Class<?>, CellProcessorBuilder> builderMap = new ConcurrentHashMap();

    public CellProcessorBuilderContainer() {
        this.init();
    }

    public void init() {
        this.builderMap.clear();
        this.registerBuilder(String.class, new StringCellProcessorBuilder());
        this.registerBuilder(Character.class, new CharacterCellProcessorBuilder());
        this.registerBuilder(Character.TYPE, new CharacterCellProcessorBuilder());
        this.registerBuilder(Boolean.class, new BooleanCellProcessorBuilder());
        this.registerBuilder(Boolean.TYPE, new BooleanCellProcessorBuilder());
        this.registerBuilder(Byte.class, new ByteCellProcessorBuilder());
        this.registerBuilder(Byte.TYPE, new ByteCellProcessorBuilder());
        this.registerBuilder(Short.class, new ShortCellProcessorBuilder());
        this.registerBuilder(Short.TYPE, new ShortCellProcessorBuilder());
        this.registerBuilder(Integer.class, new IntegerCellProcessorBuilder());
        this.registerBuilder(Integer.TYPE, new IntegerCellProcessorBuilder());
        this.registerBuilder(Long.class, new LongCellProcessorBuilder());
        this.registerBuilder(Long.TYPE, new LongCellProcessorBuilder());
        this.registerBuilder(Float.class, new FloatCellProcessorBuilder());
        this.registerBuilder(Float.TYPE, new FloatCellProcessorBuilder());
        this.registerBuilder(Double.class, new DoubleCellProcessorBuilder());
        this.registerBuilder(Double.TYPE, new DoubleCellProcessorBuilder());
        this.registerBuilder(BigDecimal.class, new BigDecimalCellProcessorBuilder());
        this.registerBuilder(BigInteger.class, new BigIntegerCellProcessorBuilder());
        this.registerBuilder(java.util.Date.class, new DateCellProcessorBuilder());
        this.registerBuilder(Date.class, new SqlDateCellProcessorBuilder());
        this.registerBuilder(Timestamp.class, new TimestampCellProcessorBuilder());
        this.registerBuilder(Time.class, new TimeCellProcessorBuilder());
        this.registerBuilder(Enum.class, new EnumCellProcessorBuilder());
        try {
            Class.forName("org.supercsv.cellprocessor.time.FmtLocalDateTime");
            this.registerBuilder(LocalDate.class, new LocalDateCellProcessorBuilder());
            this.registerBuilder(LocalDateTime.class, new org.supercsv.ext.builder.time.LocalDateTimeCellProcessorBuilder());
            this.registerBuilder(java.time.LocalTime.class, new org.supercsv.ext.builder.time.LocalTimeCellProcessorBuilder());
            this.registerBuilder(JapaneseDate.class, new LocalDateCellProcessorBuilder());
            this.registerBuilder(ZonedDateTime.class, new ZonedDateTimeCellProcessorBuilder());
            this.registerBuilder(java.time.Duration.class, new org.supercsv.ext.builder.time.DurationCellProcessorBuilder());
            this.registerBuilder(Period.class, new PeriodCellProcessorBuilder());
            this.registerBuilder(ZoneId.class, new ZoneIdCellProcessorBuilder());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("org.supercsv.cellprocessor.joda.FmtLocalDateTime");
            this.registerBuilder(org.joda.time.LocalDate.class, new org.supercsv.ext.builder.joda.LocalDateCellProcessorBuilder());
            this.registerBuilder(org.joda.time.LocalDateTime.class, new LocalDateTimeCellProcessorBuilder());
            this.registerBuilder(LocalTime.class, new LocalTimeCellProcessorBuilder());
            this.registerBuilder(Duration.class, new DurationCellProcessorBuilder());
            this.registerBuilder(Interval.class, new IntervalCellProcessorBuilder());
            this.registerBuilder(org.joda.time.Period.class, new org.supercsv.ext.builder.joda.PeriodCellProcessorBuilder());
            this.registerBuilder(DateTimeZone.class, new DateTimeZoneCellProcessorBuilder());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public <T> void registerBuilder(Class<?> type, CellProcessorBuilder<T> builder) {
        this.builderMap.put(type, builder);
    }

    public <T> CellProcessorBuilder<T> getBuilder(Class<?> type) {
        return this.builderMap.get(type);
    }
}

