/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.constraint;

import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class MaxLength
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected final int max;

    public MaxLength(int max) {
        MaxLength.checkPreconditions(max);
        this.max = max;
    }

    public MaxLength(int max, CellProcessor next) {
        super(next);
        MaxLength.checkPreconditions(max);
        this.max = max;
    }

    private static void checkPreconditions(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException(String.format("max (%d) should not be < 0", max));
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        String stringValue = value.toString();
        int length = stringValue.length();
        if (length > this.max) {
            throw new SuperCsvConstraintViolationException(String.format("the length (%d) of value '%s' does not lie the max (%d) values (inclusive)", length, stringValue, this.max), context, (CellProcessor)this);
        }
        return this.next.execute((Object)stringValue, context);
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(MaxLength.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("max", this.getMax());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

