/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.number;

import com.github.mygreen.cellformatter.number.FormattedNumber;
import com.github.mygreen.cellformatter.number.SimpleFraction;

public class FractionNumber
extends FormattedNumber {
    private String denominatorPart;
    private String numeratorPart;
    private String wholeNumberPart;
    private boolean wholeType;

    private FractionNumber(double value) {
        super(value);
    }

    public static FractionNumber createExactDenominator(double value, int exactDenom) {
        return FractionNumber.createExactDenominator(value, exactDenom, false);
    }

    public static FractionNumber createExactDenominator(double value, int exactDenom, boolean wholeType) {
        FractionNumber fractionNumber = new FractionNumber(value);
        fractionNumber.wholeType = wholeType;
        SimpleFraction fraction = SimpleFraction.createFractionExactDenominator(Math.abs(value), exactDenom);
        FractionNumber.setupFractionPart(fraction, fractionNumber);
        return fractionNumber;
    }

    public static FractionNumber createMaxDenominator(double value, int maxDenom) {
        return FractionNumber.createMaxDenominator(value, maxDenom, false);
    }

    public static FractionNumber createMaxDenominator(double value, int maxDenom, boolean wholeType) {
        FractionNumber fractionNumber = new FractionNumber(value);
        fractionNumber.wholeType = wholeType;
        SimpleFraction fraction = SimpleFraction.createFractionMaxDenominator(Math.abs(value), maxDenom);
        FractionNumber.setupFractionPart(fraction, fractionNumber);
        return fractionNumber;
    }

    private static void setupFractionPart(SimpleFraction fraction, FractionNumber fractionNumber) {
        fractionNumber.denominatorPart = String.valueOf(fraction.getDenominator());
        if (fractionNumber.isWholeType()) {
            int wholeNumber = fraction.getNumerator() / fraction.getDenominator();
            fractionNumber.wholeNumberPart = wholeNumber == 0 ? "" : String.valueOf(wholeNumber);
            int numerator = fraction.getNumerator() % fraction.getDenominator();
            fractionNumber.numeratorPart = String.valueOf(numerator);
        } else {
            fractionNumber.wholeNumberPart = "";
            fractionNumber.numeratorPart = String.valueOf(fraction.getNumerator());
        }
    }

    public boolean isWholeType() {
        return this.wholeType;
    }

    public String getDenominatorPart() {
        return this.denominatorPart;
    }

    public String getDenominatorPart(int digit) {
        int length = this.denominatorPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        return String.valueOf(this.denominatorPart.charAt(length - digit));
    }

    public String getDenominatorPartAfter(int digit) {
        int length = this.denominatorPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        return this.denominatorPart.substring(0, length - digit + 1);
    }

    public String getNumeratorPart() {
        return this.numeratorPart;
    }

    public String getNumeratorPart(int digit) {
        int length = this.numeratorPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        return String.valueOf(this.numeratorPart.charAt(length - digit));
    }

    public String getNumeratorPartAfter(int digit) {
        int length = this.numeratorPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        return this.numeratorPart.substring(0, length - digit + 1);
    }

    public String getWholeNumberPart() {
        return this.wholeNumberPart;
    }

    public String getWholeNumberPart(int digit) {
        int length = this.wholeNumberPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        return String.valueOf(this.wholeNumberPart.charAt(length - digit));
    }

    public String getWholeNumberPartAfter(int digit) {
        int length = this.wholeNumberPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        return this.wholeNumberPart.substring(0, length - digit + 1);
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isNegative()) {
            sb.append("-");
        }
        if (this.isWholeType() && !this.getWholeNumberPart().isEmpty()) {
            sb.append(this.getWholeNumberPart()).append(" ");
        }
        sb.append(this.getNumeratorPart()).append("/").append(this.getDenominatorPart());
        return sb.toString();
    }
}

