/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.number;

import com.github.mygreen.cellformatter.number.DecimalNumber;
import com.github.mygreen.cellformatter.number.ExponentNumber;
import com.github.mygreen.cellformatter.number.FractionNumber;
import com.github.mygreen.cellformatter.number.NativeNumber;
import com.github.mygreen.cellformatter.number.PercentNumber;

public abstract class FormattedNumber {
    protected final double value;
    protected boolean useSeparator;

    public FormattedNumber(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isZero() {
        return this.value == 0.0;
    }

    public boolean isPositive() {
        return this.value > 0.0;
    }

    public boolean isNegative() {
        return this.value < 0.0;
    }

    public NativeNumber asNative() {
        return (NativeNumber)this;
    }

    public DecimalNumber asDecimal() {
        return (DecimalNumber)this;
    }

    public PercentNumber asPercent() {
        return (PercentNumber)this;
    }

    public ExponentNumber asExponent() {
        return (ExponentNumber)this;
    }

    public FractionNumber asFraction() {
        return (FractionNumber)this;
    }

    public boolean isUseSeparator() {
        return this.useSeparator;
    }

    public void setUseSeparator(boolean useSeparator) {
        this.useSeparator = useSeparator;
    }
}

