/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.lang;

import com.github.mygreen.cellformatter.lang.MessageResolver;
import com.github.mygreen.cellformatter.lang.Utils;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MSLocale {
    private static final MessageResolver messageResolver = new MessageResolver("com.github.mygreen.cellformatter.locale");
    private static Map<Integer, MSLocale> KNOWN_LOCALES = new ConcurrentHashMap<Integer, MSLocale>();
    public static final MSLocale JAPANESE = MSLocale.createKnownLocale(1041);
    public static final MSLocale US = MSLocale.createKnownLocale(1033);
    public static final MSLocale UK = MSLocale.createKnownLocale(2057);
    public static final MSLocale CANADA = MSLocale.createKnownLocale(10249);
    public static final MSLocale GERMAN = MSLocale.createKnownLocale(1031);
    public static final MSLocale FRENCE = MSLocale.createKnownLocale(1036);
    public static final MSLocale CANADA_FRENCH = MSLocale.createKnownLocale(3084);
    public static final MSLocale ITALY = MSLocale.createKnownLocale(1040);
    public static final MSLocale KOREA = MSLocale.createKnownLocale(1042);
    public static final MSLocale PRC = MSLocale.createKnownLocale(2052);
    public static final MSLocale TAIWAN = MSLocale.createKnownLocale(1028);
    private final int id;
    private final String hexId;
    private String code;
    private String language;
    private String country;
    private String name;
    private Locale locale;

    public static boolean isKnownById(int id) {
        String hexId = Utils.supplyZero(Integer.toHexString(id).toUpperCase(), 4);
        String code = messageResolver.getMessage(String.format("locale.%s.code", hexId));
        return Utils.isNotEmpty(code);
    }

    public MSLocale(int id) {
        String hexId;
        this.id = id;
        this.hexId = hexId = Utils.supplyZero(Integer.toHexString(id).toUpperCase(), 4);
    }

    public static MSLocale createKnownLocale(int id) {
        if (KNOWN_LOCALES.containsKey(id)) {
            return KNOWN_LOCALES.get(id);
        }
        MSLocale locale = new MSLocale(id);
        String hexId = Utils.supplyZero(Integer.toHexString(id).toUpperCase(), 4);
        String code = messageResolver.getMessage(String.format("locale.%s.code", hexId));
        if (Utils.isEmpty(code)) {
            return null;
        }
        locale.code = code;
        locale.language = messageResolver.getMessage(String.format("locale.%s.language", hexId));
        locale.country = messageResolver.getMessage(String.format("locale.%s.country", hexId));
        locale.name = messageResolver.getMessage(String.format("locale.%s.name", hexId));
        String jid = messageResolver.getMessage(String.format("locale.%s.jid", hexId));
        if (Utils.isNotEmpty(jid)) {
            locale.locale = MSLocale.parseLocale(jid);
        }
        KNOWN_LOCALES.put(id, locale);
        return locale;
    }

    private static Locale parseLocale(String jid) {
        String[] split = jid.split("_");
        if (split.length == 1) {
            return new Locale(split[0]);
        }
        if (split.length == 2) {
            return new Locale(split[0], split[1]);
        }
        if (split.length == 3) {
            return new Locale(split[0], split[2]);
        }
        return null;
    }

    public boolean isSystemDate() {
        return this.getHexId().equalsIgnoreCase("F800");
    }

    public boolean isSystemTime() {
        return this.getHexId().equalsIgnoreCase("F400");
    }

    public int getId() {
        return this.id;
    }

    public String getHexId() {
        return this.hexId;
    }

    public String getCode() {
        return this.code;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getName() {
        return this.name;
    }

    public String getName(Locale locale) {
        return messageResolver.getMessage(locale, String.format("locale.%s.name", this.hexId));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MSLocale other = (MSLocale)obj;
        return this.id == other.id;
    }
}

