/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.lang;

import com.github.mygreen.cellformatter.lang.MessageResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public class MSColor {
    private static final MessageResolver messageResolver = new MessageResolver("com.github.mygreen.cellformatter.color");
    public static final MSColor BLACK = new MSColor(1);
    public static final MSColor WHITE = new MSColor(2);
    public static final MSColor RED = new MSColor(3);
    public static final MSColor GREEN = new MSColor(4);
    public static final MSColor BLUE = new MSColor(5);
    public static final MSColor YELLOW = new MSColor(6);
    public static final MSColor MAGENTA = new MSColor(7);
    public static final MSColor CYAN = new MSColor(8);
    public static final List<MSColor> KNOWN_COLORS = Collections.unmodifiableList(new CopyOnWriteArrayList<MSColor>(Arrays.asList(BLACK, WHITE, RED, GREEN, BLUE, YELLOW, MAGENTA, CYAN)));
    private final short index;
    private final String name;

    public MSColor(short index) {
        this.index = index;
        this.name = messageResolver.getMessage(String.format("color.%d.name", index));
    }

    public short getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getLocaleName() {
        return messageResolver.getMessage(Locale.getDefault(), String.format("color.%d.name", this.index));
    }

    public String getLocaleName(Locale locale) {
        return messageResolver.getMessage(locale, String.format("color.%d.name", this.index));
    }

    public String getHtmlColor() {
        return messageResolver.getMessage(String.format("color.%d.html", this.index));
    }

    public short[] getRgbColor() {
        String value = messageResolver.getMessage(String.format("color.%d.rgb", this.index));
        String[] split = value.split(",");
        short[] rgb = new short[]{Short.valueOf(split[0]), Short.valueOf(split[1]), Short.valueOf(split[2])};
        return rgb;
    }

    public static MSColor valueOfKnownColor(String name) {
        for (MSColor color : KNOWN_COLORS) {
            if (color.name.equalsIgnoreCase(name)) {
                return color;
            }
            if (color.getLocaleName() == null || !color.getLocaleName().equalsIgnoreCase(name)) continue;
            return color;
        }
        return null;
    }

    public static MSColor valueOfIndexColor(short index) {
        for (MSColor color : KNOWN_COLORS) {
            if (color.index != index) continue;
            return color;
        }
        return new MSColor(index);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MSColor)) {
            return false;
        }
        MSColor other = (MSColor)obj;
        return this.index == other.index;
    }
}

