/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.lang;

import com.github.mygreen.cellformatter.lang.Era;
import com.github.mygreen.cellformatter.lang.EraPeriod;
import com.github.mygreen.cellformatter.lang.ExcelDateUtils;
import com.github.mygreen.cellformatter.lang.MSLocale;
import com.github.mygreen.cellformatter.lang.MessageResolver;
import com.github.mygreen.cellformatter.lang.MessageResource;
import com.github.mygreen.cellformatter.lang.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EraResolver {
    private static final MessageResolver messageResolver = new MessageResolver("com.github.mygreen.cellformatter.era", true, true);
    private Map<Locale, Era> eras = new ConcurrentHashMap<Locale, Era>();

    public Era getEra(MSLocale locale) {
        return locale == null ? Era.UNKNOWN_ERA : this.getEra(locale.getLocale());
    }

    public Era getEra(Locale locale) {
        if (locale == null) {
            return Era.UNKNOWN_ERA;
        }
        if (this.eras.containsKey(locale)) {
            return this.eras.get(locale);
        }
        MessageResource resource = messageResolver.loadResource(locale);
        Era era = resource.isNullObject() ? Era.UNKNOWN_ERA : this.createEra(resource);
        this.eras.put(locale, era);
        return era;
    }

    private Era createEra(MessageResource resource) {
        Pattern keyPattern = Pattern.compile("^era\\.(.+)\\.name$");
        HashSet<String> keyNameSet = new HashSet<String>();
        for (String key : resource.getKeys()) {
            Matcher matcher = keyPattern.matcher(key);
            if (!matcher.matches()) continue;
            String keyName = matcher.group(1);
            keyNameSet.add(keyName);
        }
        ArrayList<EraPeriod> periodList = new ArrayList<EraPeriod>();
        for (String keyName : keyNameSet) {
            String end;
            EraPeriod period = new EraPeriod();
            String name = resource.getMessage(String.format("era.%s.name", keyName));
            period.setName(name);
            String abbrevName = resource.getMessage(String.format("era.%s.abbrevName", keyName));
            period.setAbbrevName(abbrevName);
            String abbrevRomanName = resource.getMessage(String.format("era.%s.abbrevRomanName", keyName));
            period.setAbbrevRomanName(abbrevRomanName);
            String start = resource.getMessage(String.format("era.%s.start", keyName));
            if (Utils.isNotEmpty(start)) {
                period.setStartDate(ExcelDateUtils.parseDate(start));
            }
            if (Utils.isNotEmpty(end = resource.getMessage(String.format("era.%s.end", keyName)))) {
                period.setEndDate(ExcelDateUtils.parseDate(end));
            }
            periodList.add(period);
        }
        if (periodList.isEmpty()) {
            return Era.UNKNOWN_ERA;
        }
        Era era = new Era(periodList);
        return era;
    }
}

