/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.ConditionDateFormatterFactory;
import com.github.mygreen.cellformatter.ConditionFormatter;
import com.github.mygreen.cellformatter.ConditionNumberFormatterFactory;
import com.github.mygreen.cellformatter.ConditionOperator;
import com.github.mygreen.cellformatter.ConditionTextFormatterFactory;
import com.github.mygreen.cellformatter.CustomFormatter;
import com.github.mygreen.cellformatter.CustomFormatterParseException;
import com.github.mygreen.cellformatter.tokenizer.CustomFormatTokenizer;
import com.github.mygreen.cellformatter.tokenizer.Token;
import com.github.mygreen.cellformatter.tokenizer.TokenStore;
import java.util.List;

public class CustomFormatterFactory {
    private ConditionTextFormatterFactory textFormatterFactory = new ConditionTextFormatterFactory();
    private ConditionDateFormatterFactory dateFormatterFactory = new ConditionDateFormatterFactory();
    private ConditionNumberFormatterFactory numberFormatterFactory = new ConditionNumberFormatterFactory();

    public CustomFormatter create(String pattern) {
        CustomFormatTokenizer tokenizer = new CustomFormatTokenizer();
        TokenStore allStore = tokenizer.parse(pattern);
        if (allStore.getTokens().isEmpty()) {
            return CustomFormatter.DEFAULT_FORMATTER;
        }
        if (pattern.equalsIgnoreCase("General")) {
            return CustomFormatter.DEFAULT_FORMATTER;
        }
        List<TokenStore> sections = allStore.split(Token.SYMBOL_SEMI_COLON);
        if (sections.size() > 4) {
            throw new CustomFormatterParseException(pattern, String.format("section size over 4. but '%s' number of %d secitions.", pattern, sections.size()));
        }
        CustomFormatter formatter = new CustomFormatter(pattern);
        boolean containsTextFormatter = false;
        for (TokenStore section : sections) {
            ConditionFormatter conditionFormatter;
            if (this.textFormatterFactory.isTextPattern(section)) {
                conditionFormatter = this.textFormatterFactory.create(section);
                containsTextFormatter = true;
            } else {
                conditionFormatter = this.dateFormatterFactory.isDatePattern(section) ? this.dateFormatterFactory.create(section) : (this.numberFormatterFactory.isNumberPattern(section) ? this.numberFormatterFactory.create(section) : this.numberFormatterFactory.create(section));
            }
            formatter.addConditionFormatter(conditionFormatter);
        }
        int sectionSize = sections.size();
        if (containsTextFormatter) {
            --sectionSize;
        }
        boolean hasConditionFirst = false;
        for (int i = 0; i < sectionSize; ++i) {
            ConditionFormatter conditionFormatter = formatter.getConditionFormatters().get(i);
            if (conditionFormatter.getOperator() != null) {
                if (i != 0) continue;
                hasConditionFirst = true;
                continue;
            }
            if (sectionSize <= 1) {
                conditionFormatter.setOperator(ConditionOperator.ALL);
                continue;
            }
            if (sectionSize == 2) {
                if (i == 0) {
                    conditionFormatter.setOperator(ConditionOperator.NON_NEGATIVE);
                    continue;
                }
                if (i != 1) continue;
                if (hasConditionFirst) {
                    conditionFormatter.setOperator(ConditionOperator.ALL);
                    continue;
                }
                conditionFormatter.setOperator(ConditionOperator.NEGATIVE);
                continue;
            }
            if (sectionSize == 3) {
                if (i == 0) {
                    conditionFormatter.setOperator(ConditionOperator.POSITIVE);
                    continue;
                }
                if (i == 1) {
                    conditionFormatter.setOperator(ConditionOperator.NEGATIVE);
                    continue;
                }
                conditionFormatter.setOperator(ConditionOperator.ALL);
                continue;
            }
            if (sectionSize == 4) {
                if (i == 0) {
                    conditionFormatter.setOperator(ConditionOperator.POSITIVE);
                    continue;
                }
                if (i == 1) {
                    conditionFormatter.setOperator(ConditionOperator.NEGATIVE);
                    continue;
                }
                if (i == 2) {
                    conditionFormatter.setOperator(ConditionOperator.ZERO);
                    continue;
                }
                conditionFormatter.setOperator(ConditionOperator.ALL);
                continue;
            }
            throw new CustomFormatterParseException(pattern, String.format("section size over 4. but '%s' number of %d secitions.", pattern, sections.size()));
        }
        return formatter;
    }
}

