/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CellFormatResult;
import com.github.mygreen.cellformatter.CommonCell;
import com.github.mygreen.cellformatter.ConditionFormatter;
import com.github.mygreen.cellformatter.ConditionOperator;
import com.github.mygreen.cellformatter.FormatCellType;
import com.github.mygreen.cellformatter.FormatterType;
import com.github.mygreen.cellformatter.callback.Callback;
import com.github.mygreen.cellformatter.number.FormattedNumber;
import com.github.mygreen.cellformatter.number.NumberFactory;
import com.github.mygreen.cellformatter.term.NumberTerm;
import com.github.mygreen.cellformatter.term.Term;
import com.github.mygreen.cellformatter.tokenizer.Token;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConditionNumberFormatter
extends ConditionFormatter {
    private List<Term<FormattedNumber>> terms = new CopyOnWriteArrayList<Term<FormattedNumber>>();
    private NumberFactory numberFactory;

    public ConditionNumberFormatter(String pattern) {
        super(pattern);
    }

    @Override
    public FormatterType getType() {
        return FormatterType.Number;
    }

    @Override
    public boolean isMatch(CommonCell cell) {
        if (!cell.isNumber()) {
            return false;
        }
        double value = cell.getNumberCellValue();
        return this.getOperator().isMatch(value);
    }

    @Override
    public CellFormatResult format(CommonCell cell, Locale runtimeLocale) {
        double number = cell.getNumberCellValue();
        FormattedNumber numObj = this.numberFactory.create(number);
        StringBuilder sb = new StringBuilder();
        if (this.getOperator().equals(ConditionOperator.ALL) && numObj.isNegative()) {
            sb.append("-");
        }
        for (Term<FormattedNumber> term : this.terms) {
            sb.append(term.format(numObj, this.getLocale(), runtimeLocale));
        }
        String value = sb.toString();
        for (Callback<?> callback : this.getCallbacks()) {
            Locale locale;
            if (!callback.isApplicable(locale = this.getLocale() != null ? this.getLocale().getLocale() : runtimeLocale)) continue;
            value = callback.call(number, value, locale, null);
        }
        CellFormatResult result = new CellFormatResult();
        result.setValue(number);
        result.setText(value);
        result.setTextColor(this.getColor());
        result.setSectionPattern(this.getPattern());
        result.setCellType(FormatCellType.Number);
        return result;
    }

    public void addTerm(Term<FormattedNumber> term) {
        this.terms.add(term);
    }

    public List<Term<FormattedNumber>> getTerms() {
        return this.terms;
    }

    public boolean containsSymbolTerm(Token.Symbol symbol) {
        for (Term<FormattedNumber> term : this.terms) {
            NumberTerm.SymbolTerm symbolTerm;
            if (!(term instanceof NumberTerm.SymbolTerm) || !(symbolTerm = (NumberTerm.SymbolTerm)term).getToken().equals(symbol)) continue;
            return true;
        }
        return false;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }

    public void setNumberFactory(NumberFactory numberFactory) {
        this.numberFactory = numberFactory;
    }
}

