/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner;

import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Event;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Start;
import com.github.mvp4g.mvp4g2.core.history.annotation.InitHistory;
import com.github.mvp4g.mvp4g2.core.history.annotation.NotFoundHistory;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.EventMetaModel;
import com.github.mvp4g.mvp4g2.processor.scanner.validation.EventAnnotationValidator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class EventAnnotationScanner {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private TypeElement eventBusTypeElement;
    private EventBusMetaModel eventBusMetaModel;

    private EventAnnotationScanner(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.eventBusTypeElement = builder.eventBusTypeElement;
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public EventBusMetaModel scan(RoundEnvironment roundEnvironment) throws ProcessorException {
        EventAnnotationValidator eventAnnotationValidator = EventAnnotationValidator.builder().roundEnvironment(roundEnvironment).processingEnvironment(this.processingEnvironment).eventBusMetaModel(this.eventBusMetaModel).eventBusTypeElement(this.eventBusTypeElement).build();
        eventAnnotationValidator.validate();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Event.class)) {
            EventAnnotationValidator.builder().roundEnvironment(roundEnvironment).processingEnvironment(this.processingEnvironment).eventBusMetaModel(this.eventBusMetaModel).eventBusTypeElement(this.eventBusTypeElement).build().validate(element);
            ExecutableElement executableElement = (ExecutableElement)element;
            EventMetaModel model = this.restore(element);
            Event eventAnnotation = element.getAnnotation(Event.class);
            model.setEventInternalName(this.processorUtils.createInternalEventName(executableElement));
            model.setEventName(executableElement.getSimpleName().toString());
            model.setHistoryEventName(eventAnnotation.historyName());
            model.setNavigationEvent(Boolean.toString(eventAnnotation.navigationEvent()));
            model.setPassive(Boolean.toString(eventAnnotation.passive()));
            model.setHandlers(this.getElementsFromAnnotationAsList(executableElement, "handlers"));
            model.setBindings(this.getElementsFromAnnotationAsList(executableElement, "bind"));
            model.setActivateHandlers(this.getElementsFromAnnotationAsList(executableElement, "activate"));
            model.setDeactivateHandlers(this.getElementsFromAnnotationAsList(executableElement, "deactivate"));
            model.setHistoryConverter(Objects.requireNonNull(this.getHistoryConverterTypeElement(eventAnnotation)).getQualifiedName().toString());
            model.setStartEvent(Objects.isNull(executableElement.getAnnotation(Start.class)) ? "false" : "true");
            model.setInitHistory(Objects.isNull(executableElement.getAnnotation(InitHistory.class)) ? "false" : "true");
            model.setNotFoundHistory(Objects.isNull(executableElement.getAnnotation(NotFoundHistory.class)) ? "false" : "true");
            executableElement.getParameters().forEach(v -> model.addParameter(v.getSimpleName().toString(), v.asType().toString()));
            this.processorUtils.store(model, this.createRelativeFileName(element));
            this.eventBusMetaModel.add(model);
        }
        return this.eventBusMetaModel;
    }

    private EventMetaModel restore(Element element) {
        Properties props = new Properties();
        try {
            FileObject resource = this.processingEnvironment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.createRelativeFileName(element));
            props.load(resource.openInputStream());
            return new EventMetaModel(props);
        }
        catch (IOException iOException) {
            return new EventMetaModel();
        }
    }

    private List<String> getElementsFromAnnotationAsList(ExecutableElement executableElement, String attribute) {
        TypeElement eventAnnotation = this.processingEnvironment.getElementUtils().getTypeElement(Event.class.getName());
        TypeMirror eventAnnotationAsTypeMirror = eventAnnotation.asType();
        return executableElement.getAnnotationMirrors().stream().filter(annotationMirror -> annotationMirror.getAnnotationType().equals(eventAnnotationAsTypeMirror)).flatMap(annotationMirror -> annotationMirror.getElementValues().entrySet().stream()).filter(entry -> attribute.equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).findFirst().map(entry -> Arrays.stream(((AnnotationValue)entry.getValue()).toString().replace("{", "").replace("}", "").replace(" ", "").split(",")).map(v -> v.substring(0, v.indexOf(".class"))).collect(Collectors.toList())).orElse(null);
    }

    private TypeElement getHistoryConverterTypeElement(Event eventAnnotation) {
        try {
            eventAnnotation.historyConverter();
        }
        catch (MirroredTypeException exception) {
            return (TypeElement)this.processingEnvironment.getTypeUtils().asElement(exception.getTypeMirror());
        }
        return null;
    }

    private String createRelativeFileName(Element element) {
        return "META-INF/mvp4g2/" + this.processorUtils.createInternalEventName((ExecutableElement)element) + ".properties";
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;
        TypeElement eventBusTypeElement;
        EventBusMetaModel eventBusMetaModel;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder eventBusTypeElement(TypeElement eventBusTypeElement) {
            this.eventBusTypeElement = eventBusTypeElement;
            return this;
        }

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public EventAnnotationScanner build() {
            return new EventAnnotationScanner(this);
        }
    }
}

