/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.core.history.annotation.History;
import com.github.mvp4g.mvp4g2.core.internal.history.HistoryMetaData;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.HistoryMetaModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class HistoryGenerator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;

    private HistoryGenerator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate(HistoryMetaModel metaModel) throws ProcessorException {
        for (String historyConverterClassName : metaModel.getHistoryConverterClassNames()) {
            HistoryMetaModel.HistoryData historyData = metaModel.getHistoryData(historyConverterClassName);
            TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)this.processorUtils.createHistoryMetaDataClassName(historyData.getHistoryConverter().getClassName())).superclass((TypeName)ClassName.get(HistoryMetaData.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($S, $T.$L)", new Object[]{historyConverterClassName, ClassName.get(History.HistoryConverterType.class), historyData.getHistoryConverterType()}).build();
            typeSpec.addMethod(constructor);
            JavaFile javaFile = JavaFile.builder((String)historyData.getHistoryConverter().getPackage(), (TypeSpec)typeSpec.build()).build();
            try {
                javaFile.writeTo(this.processingEnvironment.getFiler());
            }
            catch (IOException e) {
                throw new ProcessorException("Unable to write generated file: >>" + this.processorUtils.createHistoryMetaDataClassName(historyData.getHistoryConverter().getClassName()) + "<< -> exception: " + e.getMessage());
            }
        }
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public HistoryGenerator build() {
            return new HistoryGenerator(this);
        }
    }
}

