/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Debug;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public class DebugGenerator {
    private EventBusMetaModel eventBusMetaModel;
    private TypeSpec.Builder typeSpec;

    private DebugGenerator() {
    }

    private DebugGenerator(Builder builder) {
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.typeSpec = builder.typeSpec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate() throws ProcessorException {
        MethodSpec.Builder loadDebugConfigurationMethod = MethodSpec.methodBuilder((String)"loadDebugConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.eventBusMetaModel.hasDebugAnnotation()) {
            loadDebugConfigurationMethod.addStatement("super.setDebugEnable(true)", new Object[0]).addStatement("super.setLogger(new $T())", new Object[]{this.eventBusMetaModel.getDebugLogger().getTypeName()}).addStatement("super.setLogLevel($T.LogLevel.$L)", new Object[]{Debug.class, this.eventBusMetaModel.getDebugLogLevel()});
        } else {
            loadDebugConfigurationMethod.addStatement("super.setDebugEnable(false)", new Object[0]);
        }
        this.typeSpec.addMethod(loadDebugConfigurationMethod.build());
    }

    public static final class Builder {
        EventBusMetaModel eventBusMetaModel;
        TypeSpec.Builder typeSpec;

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public Builder typeSpec(TypeSpec.Builder typeSpec) {
            this.typeSpec = typeSpec;
            return this;
        }

        public DebugGenerator build() {
            return new DebugGenerator(this);
        }
    }
}

