/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.predicate;

import br.com.fluentvalidator.predicate.LocalDatePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.PredicateBuilder;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.function.Function;
import java.util.function.Predicate;

public final class LocalDateTimePredicate {
    public static <T extends LocalDateTime> Predicate<T> localDateTimeAfterToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDateTime -> LocalDatePredicate.localDateAfterToday().test(localDateTime.toLocalDate()));
    }

    public static <T> Predicate<T> localDateTimeAfterToday(Function<T, LocalDateTime> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeAfterToday().test((LocalDateTime)source.apply(obj)));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeAfterOrEqualToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDateTime -> LocalDatePredicate.localDateAfterOrEqualToday().test(localDateTime.toLocalDate()));
    }

    public static <T> Predicate<T> localDateTimeAfterOrEqualToday(Function<T, LocalDateTime> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeAfterOrEqualToday().test((LocalDateTime)source.apply(obj)));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeBeforeToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDateTime -> LocalDatePredicate.localDateBeforeToday().test(localDateTime.toLocalDate()));
    }

    public static <T> Predicate<T> localDateTimeBeforeToday(Function<T, LocalDateTime> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeBeforeToday().test((LocalDateTime)source.apply(obj)));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeBeforeOrEqualToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDateTime -> LocalDatePredicate.localDateBeforeOrEqualToday().test(localDateTime.toLocalDate()));
    }

    public static <T> Predicate<T> localDateTimeBeforeOrEqualToday(Function<T, LocalDateTime> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeBeforeOrEqualToday().test((LocalDateTime)source.apply(obj)));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeIsToday() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDateTime -> LocalDatePredicate.localDateIsToday().test(localDateTime.toLocalDate()));
    }

    public static <T> Predicate<T> localDateTimeIsToday(Function<T, LocalDateTime> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeIsToday().test((LocalDateTime)source.apply(obj)));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeAfterNow() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDateTime -> LocalDateTimePredicate.localDateTimeAfter(LocalDateTime.now()).test((LocalDateTime)localDateTime));
    }

    public static <T> Predicate<T> localDateTimeAfterNow(Function<T, LocalDateTime> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeAfterNow().test((LocalDateTime)source.apply(obj)));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeBeforeNow() {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(localDateTime -> LocalDateTimePredicate.localDateTimeBefore(LocalDateTime.now()).test((LocalDateTime)localDateTime));
    }

    public static <T> Predicate<T> localDateTimeBeforeNow(Function<T, LocalDateTime> source) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeBeforeNow().test((LocalDateTime)source.apply(obj)));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeEqualTo(LocalDateTime localDateTime) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(localDateTime)).and(obj -> localDateTime.isEqual((ChronoLocalDateTime<?>)obj));
    }

    public static <T> Predicate<T> localDateTimeEqualTo(Function<T, LocalDateTime> source, LocalDateTime localDateTime) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeEqualTo(localDateTime).test((LocalDateTime)source.apply(obj)));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeAfter(LocalDateTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(obj -> obj.isAfter(target));
    }

    public static <T> Predicate<T> localDateTimeAfter(Function<T, LocalDateTime> source, LocalDateTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeAfter(target).test((LocalDateTime)source.apply(obj)));
    }

    public static <T> Predicate<T> localDateTimeAfter(Function<T, LocalDateTime> source, Function<T, LocalDateTime> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalDateTimePredicate.localDateTimeAfter(source, (LocalDateTime)target.apply(obj)).test(obj));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeAfterOrEqual(LocalDateTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(LogicalPredicate.is(LocalDateTimePredicate.localDateTimeAfter(target)).or(LocalDateTimePredicate.localDateTimeEqualTo(target)));
    }

    public static <T> Predicate<T> localDateTimeAfterOrEqual(Function<T, LocalDateTime> source, LocalDateTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeAfterOrEqual(target).test((LocalDateTime)source.apply(obj)));
    }

    public static <T> Predicate<T> localDateTimeAfterOrEqual(Function<T, LocalDateTime> source, Function<T, LocalDateTime> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalDateTimePredicate.localDateTimeAfterOrEqual(source, (LocalDateTime)target.apply(obj)).test(obj));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeBefore(LocalDateTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(obj -> obj.isBefore(target));
    }

    public static <T> Predicate<T> localDateTimeBefore(Function<T, LocalDateTime> source, LocalDateTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeBefore(target).test((LocalDateTime)source.apply(obj)));
    }

    public static <T> Predicate<T> localDateTimeBefore(Function<T, LocalDateTime> source, Function<T, LocalDateTime> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalDateTimePredicate.localDateTimeBefore(source, (LocalDateTime)target.apply(obj)).test(obj));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeBeforeOrEqual(LocalDateTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(obj -> LogicalPredicate.not(ObjectPredicate.nullValue()).test(target)).and(LogicalPredicate.is(LocalDateTimePredicate.localDateTimeBefore(target)).or(LocalDateTimePredicate.localDateTimeEqualTo(target)));
    }

    public static <T> Predicate<T> localDateTimeBeforeOrEqual(Function<T, LocalDateTime> source, LocalDateTime target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeBeforeOrEqual(target).test((LocalDateTime)source.apply(obj)));
    }

    public static <T> Predicate<T> localDateTimeBeforeOrEqual(Function<T, LocalDateTime> source, Function<T, LocalDateTime> target) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(target))).and(obj -> LocalDateTimePredicate.localDateTimeBeforeOrEqual(source, (LocalDateTime)target.apply(obj)).test(obj));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeBetween(LocalDateTime min, LocalDateTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LocalDateTimePredicate.localDateTimeAfter(min).and(LocalDateTimePredicate.localDateTimeBefore(max)));
    }

    public static <T> Predicate<T> localDateTimeBetween(Function<T, LocalDateTime> source, LocalDateTime min, LocalDateTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeBetween(min, max).test((LocalDateTime)source.apply(obj)));
    }

    public static <T> Predicate<T> localDateTimeBetween(Function<T, LocalDateTime> source, Function<T, LocalDateTime> min, LocalDateTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(obj -> LocalDateTimePredicate.localDateTimeBetween(source, (LocalDateTime)min.apply(obj), max).test(obj));
    }

    public static <T> Predicate<T> localDateTimeBetween(Function<T, LocalDateTime> source, LocalDateTime min, Function<T, LocalDateTime> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalDateTimePredicate.localDateTimeBetween(source, min, (LocalDateTime)max.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateTimeBetween(Function<T, LocalDateTime> source, Function<T, LocalDateTime> min, Function<T, LocalDateTime> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalDateTimePredicate.localDateTimeBetween(source, (LocalDateTime)min.apply(obj), (LocalDateTime)max.apply(obj)).test(obj));
    }

    public static <T extends LocalDateTime> Predicate<T> localDateTimeBetweenOrEqual(LocalDateTime min, LocalDateTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LocalDateTimePredicate.localDateTimeAfterOrEqual(min).and(LocalDateTimePredicate.localDateTimeBeforeOrEqual(max)));
    }

    public static <T> Predicate<T> localDateTimeBetweenOrEqual(Function<T, LocalDateTime> source, LocalDateTime min, LocalDateTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(source))).and(obj -> LocalDateTimePredicate.localDateTimeBetweenOrEqual(min, max).test((LocalDateTime)source.apply(obj)));
    }

    public static <T> Predicate<T> localDateTimeBetweenOrEqual(Function<T, LocalDateTime> source, Function<T, LocalDateTime> min, LocalDateTime max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(obj -> LocalDateTimePredicate.localDateTimeBetweenOrEqual(source, (LocalDateTime)min.apply(obj), max).test(obj));
    }

    public static <T> Predicate<T> localDateTimeBetweenOrEqual(Function<T, LocalDateTime> source, LocalDateTime min, Function<T, LocalDateTime> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalDateTimePredicate.localDateTimeBetweenOrEqual(source, min, (LocalDateTime)max.apply(obj)).test(obj));
    }

    public static <T> Predicate<T> localDateTimeBetweenOrEqual(Function<T, LocalDateTime> source, Function<T, LocalDateTime> min, Function<T, LocalDateTime> max) {
        return PredicateBuilder.from(LogicalPredicate.not(ObjectPredicate.nullValue())).and(LogicalPredicate.not(ObjectPredicate.nullValue(min))).and(LogicalPredicate.not(ObjectPredicate.nullValue(max))).and(obj -> LocalDateTimePredicate.localDateTimeBetweenOrEqual(source, (LocalDateTime)min.apply(obj), (LocalDateTime)max.apply(obj)).test(obj));
    }

    private LocalDateTimePredicate() {
    }
}

