/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.context;

import br.com.fluentvalidator.context.Error;
import br.com.fluentvalidator.context.ValidationResult;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class ValidationContext {
    private static final ThreadLocal<Context> threadLocal = new ThreadLocal();

    private ValidationContext() {
    }

    public static Context get() {
        if (Objects.isNull(threadLocal.get())) {
            threadLocal.set(new Context());
        }
        return threadLocal.get();
    }

    public static void remove() {
        threadLocal.remove();
    }

    public static final class Context {
        private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
        private final Queue<Error> errors = new ConcurrentLinkedQueue<Error>();

        public void addErrors(Collection<Error> errs) {
            errs.stream().forEach(this.errors::add);
        }

        public void setProperty(String property, Object value) {
            if (Objects.nonNull(property)) {
                this.properties.put(property, value);
            }
        }

        public ValidationResult getValidationResult() {
            ValidationContext.remove();
            return this.errors.isEmpty() ? ValidationResult.ok() : ValidationResult.fail(this.errors);
        }

        public <P> P getProperty(String property, Class<P> clazz) {
            return clazz.cast(this.properties.getOrDefault(property, null));
        }
    }
}

