/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.mpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.builder.WheneverProperty;
import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.model.mpm.MerchantAccountInformation;
import com.emv.qrcode.model.mpm.MerchantAccountInformationReserved;
import com.emv.qrcode.model.mpm.MerchantAccountInformationReservedAdditional;
import com.emv.qrcode.model.mpm.MerchantAccountInformationTemplate;
import com.emv.qrcode.validators.mpm.MerchantAccountInformationReservedAdditionalValidator;
import com.emv.qrcode.validators.mpm.MerchantAccountInformationReservedValidator;
import java.util.function.Function;
import java.util.function.Predicate;

class MerchantAccountInformationTemplateValidator
extends AbstractValidator<MerchantAccountInformationTemplate> {
    private final String tagStart;
    private final String tagEnd;
    private final Integer maxSizeValue;

    public MerchantAccountInformationTemplateValidator(String tagStart, String tagEnd, Integer maxSizeValue) {
        this.tagStart = tagStart;
        this.tagEnd = tagEnd;
        this.maxSizeValue = maxSizeValue;
    }

    public void rules() {
        this.ruleFor("MerchantAccountInformationTemplate", MerchantAccountInformationTemplate::getTag).must(ComparablePredicate.betweenInclusive((Object)this.tagStart, (Object)this.tagEnd)).critical();
        this.ruleFor("MerchantAccountInformationTemplate", FunctionBuilder.of(MerchantAccountInformationTemplate::getValue).andThen(Object::toString)).must(StringPredicate.stringSizeBetween((Integer)1, (Integer)this.maxSizeValue)).critical();
        this.ruleFor("MerchantAccountInformationTemplate", merchantAccountInformationTemplate -> merchantAccountInformationTemplate).must(ComparablePredicate.betweenInclusive(MerchantAccountInformationTemplate::getTag, (Comparable)((Object)"02"), (Comparable)((Object)"25"))).when(ObjectPredicate.instanceOf(MerchantAccountInformationTemplate::getValue, MerchantAccountInformationReserved.class)).withMessage("MerchantAccountInformation reserved tag must be between '02' and '25'").withAttempedValue(MerchantAccountInformationTemplate::getTag).must(ComparablePredicate.betweenInclusive(MerchantAccountInformationTemplate::getTag, (Comparable)((Object)"26"), (Comparable)((Object)"51"))).when(ObjectPredicate.instanceOf(MerchantAccountInformationTemplate::getValue, MerchantAccountInformationReservedAdditional.class)).withMessage("MerchantAccountInformation reserved additional tag must be between '26' and '51'").withAttempedValue(MerchantAccountInformationTemplate::getTag);
        ((WheneverProperty)this.ruleFor(this.convert(MerchantAccountInformationReserved.class)).whenever(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue()))).withValidator((Validator)new MerchantAccountInformationReservedValidator());
        ((WheneverProperty)this.ruleFor(this.convert(MerchantAccountInformationReservedAdditional.class)).whenever(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue()))).withValidator((Validator)new MerchantAccountInformationReservedAdditionalValidator());
    }

    private <T extends MerchantAccountInformation> Function<MerchantAccountInformationTemplate, T> convert(Class<T> clazz) {
        return fn -> clazz.isInstance(fn.getValue()) ? (MerchantAccountInformation)clazz.cast(fn.getValue()) : null;
    }
}

