/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.cpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.core.model.cpm.BERTLV;
import com.emv.qrcode.model.cpm.AdditionalData;
import com.emv.qrcode.model.cpm.ApplicationTemplate;
import java.util.function.Predicate;

class ApplicationTemplateValidator
extends AbstractValidator<ApplicationTemplate> {
    ApplicationTemplateValidator() {
    }

    public void rules() {
        this.ruleFor("ApplicationDefinitionFileName", AdditionalData::getApplicationDefinitionFileName).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(BERTLV::getStringValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationDefinitionFileName value must be present").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue)).must(ComparablePredicate.betweenInclusive(BERTLV::getLength, (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(16))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationDefinitionFileName value size must be between five and sixteen").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("ApplicationLabel", AdditionalData::getApplicationLabel).must(ComparablePredicate.betweenInclusive(BERTLV::getLength, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(16))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationLabel value size must be between five and sixteen").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("ApplicationPAN", AdditionalData::getApplicationPAN).must(ComparablePredicate.lessThanOrEqual(BERTLV::getLength, (Comparable)Integer.valueOf(10))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationPAN value size must be less than or equal ten").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("ApplicationVersionNumber", AdditionalData::getApplicationVersionNumber).must(ComparablePredicate.equalTo(BERTLV::getLength, (Comparable)Integer.valueOf(2))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ApplicationVersionNumber value size must be equal two").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("CardholderName", AdditionalData::getCardholderName).must(ComparablePredicate.betweenInclusive(BERTLV::getLength, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(26))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("CardholderName value size must be between two and twenty-six").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("Last4DigitsOfPAN", AdditionalData::getLast4DigitsOfPAN).must(ComparablePredicate.equalTo(BERTLV::getLength, (Comparable)Integer.valueOf(2))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("Last4DigitsOfPAN value size must be equal two").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("LanguagePreference", AdditionalData::getLanguagePreference).must(ComparablePredicate.betweenInclusive(BERTLV::getLength, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("LanguagePreference value size must be between two and eight").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("Track2EquivalentData", AdditionalData::getTrack2EquivalentData).must(ComparablePredicate.lessThanOrEqual(BERTLV::getLength, (Comparable)Integer.valueOf(19))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("Track2EquivalentData value size must be less than or equal nineteen").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("TokenRequestorID", AdditionalData::getTokenRequestorID).must(ComparablePredicate.equalTo(BERTLV::getLength, (Comparable)Integer.valueOf(6))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TokenRequestorID value size must be equal six").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
        this.ruleFor("PaymentAccountReference", AdditionalData::getPaymentAccountReference).must(ComparablePredicate.equalTo(BERTLV::getLength, (Comparable)Integer.valueOf(29))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("PaymentAccountReference value size must be equal twenty-nine").withAttempedValue((Object)FunctionBuilder.of(BERTLV::getStringValue));
    }
}

