/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.context.ValidationResult;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.core.CRC;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public final class Crc16Validate {
    private static final Validator<String> VALIDATOR = new Crc16Validator();

    private Crc16Validate() {
    }

    public static final ValidationResult validate(String instance) {
        return VALIDATOR.validate((Object)instance);
    }

    static class Crc16Validator
    extends AbstractValidator<String> {
        Crc16Validator() {
        }

        public void rules() {
            this.failFastRule();
            this.ruleFor("CRC", value -> value).must(StringPredicate.stringSizeGreaterThanOrEqual((Integer)4)).withMessage("Invalid EMV, size less than four").withAttempedValue(StringUtils::length);
            this.ruleFor("CRC", value -> value).must(StringPredicate.stringEquals(Crc16Validator.calcCrc16(), Crc16Validator.extractCrc16())).when(StringPredicate.stringSizeGreaterThanOrEqual((Integer)4)).withMessage("Invalid CRC16").withAttempedValue(value -> StringUtils.right((String)value, (int)4));
        }

        private static Function<String, String> extractCrc16() {
            return value -> StringUtils.right((String)value, (int)4);
        }

        private static Function<String, String> calcCrc16() {
            return value -> String.format("%04X", CRC.crc16(value.substring(0, value.length() - 4).getBytes(StandardCharsets.UTF_8)));
        }
    }
}

