/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.exception.DuplicateTagException;
import com.emv.qrcode.core.exception.InvalidTagException;
import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.core.model.mpm.TagLengthString;
import com.emv.qrcode.core.utils.TLVUtils;
import com.emv.qrcode.decoder.mpm.DecoderMpm;
import com.emv.qrcode.model.mpm.AdditionalDataFieldTemplate;
import com.emv.qrcode.model.mpm.MerchantAccountInformationTemplate;
import com.emv.qrcode.model.mpm.MerchantInformationLanguageTemplate;
import com.emv.qrcode.model.mpm.MerchantPresentedMode;
import com.emv.qrcode.model.mpm.UnreservedTemplate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class MerchantPresentedModeDecoder
extends DecoderMpm<MerchantPresentedMode> {
    private static final Map<String, Map.Entry<Class<?>, BiConsumer<MerchantPresentedMode, ?>>> mapConsumers = new HashMap();

    public MerchantPresentedModeDecoder(String source) {
        super(source);
    }

    @Override
    protected MerchantPresentedMode decode() throws PresentedModeException {
        HashSet<String> tags = new HashSet<String>();
        MerchantPresentedMode result = new MerchantPresentedMode();
        result.setCRC("0000");
        while (this.iterator.hasNext()) {
            String value = (String)this.iterator.next();
            String tag = TLVUtils.valueOfTag(value);
            String derivateId = this.derivateId(tag);
            if (tags.contains(tag)) {
                throw new DuplicateTagException("MerchantPresentedMode", tag, value);
            }
            tags.add(tag);
            Map.Entry<Class<?>, BiConsumer<MerchantPresentedMode, ?>> entry = mapConsumers.get(derivateId);
            if (Objects.isNull(entry)) {
                throw new InvalidTagException("MerchantPresentedMode", tag, value);
            }
            Class<?> clazz = entry.getKey();
            BiConsumer<MerchantPresentedMode, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderMpm.decode(value, clazz));
        }
        return result;
    }

    private String derivateId(String id) {
        if (this.betweenAccountInformationReservedRange(id)) {
            return "02";
        }
        if (this.betweenAccountInformationaReservedAdditionalRange(id)) {
            return "26";
        }
        if (this.betweenRFUForEMVCORange(id)) {
            return "65";
        }
        if (this.betweenUnreservedTemplatesRange(id)) {
            return "80";
        }
        return id;
    }

    private boolean betweenAccountInformationReservedRange(String value) {
        return value.compareTo("02") >= 0 && value.compareTo("25") <= 0;
    }

    private boolean betweenAccountInformationaReservedAdditionalRange(String value) {
        return value.compareTo("26") >= 0 && value.compareTo("51") <= 0;
    }

    private boolean betweenRFUForEMVCORange(String value) {
        return value.compareTo("65") >= 0 && value.compareTo("79") <= 0;
    }

    private boolean betweenUnreservedTemplatesRange(String value) {
        return value.compareTo("80") >= 0 && value.compareTo("99") <= 0;
    }

    static {
        mapConsumers.put("00", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setPayloadFormatIndicator));
        mapConsumers.put("01", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setPointOfInitiationMethod));
        mapConsumers.put("52", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setMerchantCategoryCode));
        mapConsumers.put("53", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setTransactionCurrency));
        mapConsumers.put("54", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setTransactionAmount));
        mapConsumers.put("55", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setTipOrConvenienceIndicator));
        mapConsumers.put("56", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setValueOfConvenienceFeeFixed));
        mapConsumers.put("57", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setValueOfConvenienceFeePercentage));
        mapConsumers.put("58", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setCountryCode));
        mapConsumers.put("59", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setMerchantName));
        mapConsumers.put("60", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setMerchantCity));
        mapConsumers.put("61", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setPostalCode));
        mapConsumers.put("63", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setCRC));
        mapConsumers.put("62", MerchantPresentedModeDecoder.consumerTagLengthValue(AdditionalDataFieldTemplate.class, MerchantPresentedMode::setAdditionalDataField));
        mapConsumers.put("64", MerchantPresentedModeDecoder.consumerTagLengthValue(MerchantInformationLanguageTemplate.class, MerchantPresentedMode::setMerchantInformationLanguage));
        mapConsumers.put("02", MerchantPresentedModeDecoder.consumerTagLengthValue(MerchantAccountInformationTemplate.class, MerchantPresentedMode::addMerchantAccountInformation));
        mapConsumers.put("26", MerchantPresentedModeDecoder.consumerTagLengthValue(MerchantAccountInformationTemplate.class, MerchantPresentedMode::addMerchantAccountInformation));
        mapConsumers.put("65", MerchantPresentedModeDecoder.consumerTagLengthValue(TagLengthString.class, MerchantPresentedMode::addRFUforEMVCo));
        mapConsumers.put("80", MerchantPresentedModeDecoder.consumerTagLengthValue(UnreservedTemplate.class, MerchantPresentedMode::addUnreserved));
        mapConsumers.put("63", MerchantPresentedModeDecoder.consumerTagLengthValue(String.class, MerchantPresentedMode::setCRC));
    }
}

