/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.exception.DuplicateTagException;
import com.emv.qrcode.core.exception.InvalidTagException;
import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.core.model.mpm.TagLengthString;
import com.emv.qrcode.core.utils.TLVUtils;
import com.emv.qrcode.decoder.mpm.DecoderMpm;
import com.emv.qrcode.model.mpm.MerchantInformationLanguage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class MerchantInformationLanguageDecoder
extends DecoderMpm<MerchantInformationLanguage> {
    private static final Map<String, Map.Entry<Class<?>, BiConsumer<MerchantInformationLanguage, ?>>> mapConsumers = new HashMap();

    public MerchantInformationLanguageDecoder(String source) {
        super(TLVUtils.valueOf(source));
    }

    @Override
    protected MerchantInformationLanguage decode() throws PresentedModeException {
        HashSet<String> tags = new HashSet<String>();
        MerchantInformationLanguage result = new MerchantInformationLanguage();
        while (this.iterator.hasNext()) {
            String value = (String)this.iterator.next();
            String tag = TLVUtils.valueOfTag(value);
            String derivateId = this.derivateId(tag);
            if (tags.contains(tag)) {
                throw new DuplicateTagException("MerchantInformationLanguage", tag, value);
            }
            tags.add(tag);
            Map.Entry<Class<?>, BiConsumer<MerchantInformationLanguage, ?>> entry = mapConsumers.get(derivateId);
            if (Objects.isNull(entry)) {
                throw new InvalidTagException("MerchantInformationLanguage", tag, value);
            }
            Class<?> clazz = entry.getKey();
            BiConsumer<MerchantInformationLanguage, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderMpm.decode(value, clazz));
        }
        return result;
    }

    private String derivateId(String id) {
        if (this.betweenRFUForEMVCORange(id)) {
            return "03";
        }
        return id;
    }

    private boolean betweenRFUForEMVCORange(String value) {
        return value.compareTo("03") >= 0 && value.compareTo("99") <= 0;
    }

    static {
        mapConsumers.put("00", MerchantInformationLanguageDecoder.consumerTagLengthValue(String.class, MerchantInformationLanguage::setLanguagePreference));
        mapConsumers.put("01", MerchantInformationLanguageDecoder.consumerTagLengthValue(String.class, MerchantInformationLanguage::setMerchantName));
        mapConsumers.put("02", MerchantInformationLanguageDecoder.consumerTagLengthValue(String.class, MerchantInformationLanguage::setMerchantCity));
        mapConsumers.put("03", MerchantInformationLanguageDecoder.consumerTagLengthValue(TagLengthString.class, MerchantInformationLanguage::addRFUforEMVCo));
    }
}

