/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.exception.DuplicateTagException;
import com.emv.qrcode.core.exception.InvalidTagException;
import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.core.model.mpm.TagLengthString;
import com.emv.qrcode.core.utils.TLVUtils;
import com.emv.qrcode.decoder.mpm.DecoderMpm;
import com.emv.qrcode.model.mpm.MerchantAccountInformationReservedAdditional;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class MerchantAccountInformationReservedAdditionalDecoder
extends DecoderMpm<MerchantAccountInformationReservedAdditional> {
    private static final Map<String, Map.Entry<Class<?>, BiConsumer<MerchantAccountInformationReservedAdditional, ?>>> mapConsumers = new HashMap();

    public MerchantAccountInformationReservedAdditionalDecoder(String source) {
        super(TLVUtils.valueOf(source));
    }

    @Override
    protected MerchantAccountInformationReservedAdditional decode() throws PresentedModeException {
        HashSet<String> tags = new HashSet<String>();
        MerchantAccountInformationReservedAdditional result = new MerchantAccountInformationReservedAdditional();
        while (this.iterator.hasNext()) {
            String value = (String)this.iterator.next();
            String tag = TLVUtils.valueOfTag(value);
            String derivateId = this.derivateId(tag);
            if (tags.contains(tag)) {
                throw new DuplicateTagException("MerchantAccountInformation", tag, value);
            }
            tags.add(tag);
            Map.Entry<Class<?>, BiConsumer<MerchantAccountInformationReservedAdditional, ?>> entry = mapConsumers.get(derivateId);
            if (Objects.isNull(entry)) {
                throw new InvalidTagException("MerchantAccountInformation", tag, value);
            }
            Class<?> clazz = entry.getKey();
            BiConsumer<MerchantAccountInformationReservedAdditional, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderMpm.decode(value, clazz));
        }
        return result;
    }

    private String derivateId(String id) {
        if (this.betweenPaymentNetworkSpecificRange(id)) {
            return "01";
        }
        return id;
    }

    private boolean betweenPaymentNetworkSpecificRange(String value) {
        return value.compareTo("01") >= 0 && value.compareTo("99") <= 0;
    }

    static {
        mapConsumers.put("00", MerchantAccountInformationReservedAdditionalDecoder.consumerTagLengthValue(String.class, MerchantAccountInformationReservedAdditional::setGloballyUniqueIdentifier));
        mapConsumers.put("01", MerchantAccountInformationReservedAdditionalDecoder.consumerTagLengthValue(TagLengthString.class, MerchantAccountInformationReservedAdditional::addPaymentNetworkSpecific));
    }
}

