/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.cpm;

import com.emv.qrcode.core.exception.DuplicateTagException;
import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.core.model.cpm.BERTag;
import com.emv.qrcode.core.utils.BERUtils;
import com.emv.qrcode.decoder.cpm.DecoderCpm;
import com.emv.qrcode.model.cpm.ApplicationTemplate;
import com.emv.qrcode.model.cpm.CommonDataTemplate;
import com.emv.qrcode.model.cpm.ConsumerPresentedMode;
import com.emv.qrcode.model.cpm.PayloadFormatIndicator;
import com.emv.qrcode.model.cpm.constants.ConsumerPresentedModeFieldCodes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.codec.binary.Hex;

public final class ConsumerPresentedModeDecoder
extends DecoderCpm<ConsumerPresentedMode> {
    private static final Set<BERTag> denyDuplicateTags = new HashSet<BERTag>();
    private static final Map<BERTag, Map.Entry<Class<?>, BiConsumer<ConsumerPresentedMode, ?>>> mapConsumers = new HashMap();

    public ConsumerPresentedModeDecoder(byte[] source) {
        super(source);
    }

    @Override
    protected ConsumerPresentedMode decode() throws PresentedModeException {
        HashSet<BERTag> tags = new HashSet<BERTag>();
        ConsumerPresentedMode result = new ConsumerPresentedMode();
        while (this.iterator.hasNext()) {
            byte[] value = (byte[])this.iterator.next();
            BERTag tag = new BERTag(BERUtils.valueOfTag(value));
            if (tags.contains(tag)) {
                throw new DuplicateTagException("ConsumerPresentedMode", tag.toString(), Hex.encodeHexString((byte[])value, (boolean)false));
            }
            if (denyDuplicateTags.contains(tag)) {
                tags.add(tag);
            }
            Map.Entry<Class<?>, BiConsumer<ConsumerPresentedMode, ?>> entry = mapConsumers.get(tag);
            Class<?> clazz = entry.getKey();
            BiConsumer<ConsumerPresentedMode, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderCpm.decode(value, clazz));
        }
        return result;
    }

    static {
        mapConsumers.put(ConsumerPresentedModeFieldCodes.ID_PAYLOAD_FORMAT_INDICATOR, ConsumerPresentedModeDecoder.consumerTagLengthValue(PayloadFormatIndicator.class, ConsumerPresentedMode::setPayloadFormatIndicator));
        mapConsumers.put(ConsumerPresentedModeFieldCodes.ID_APPLICATION_TEMPLATE, ConsumerPresentedModeDecoder.consumerTagLengthValue(ApplicationTemplate.class, ConsumerPresentedMode::addApplicationTemplate));
        mapConsumers.put(ConsumerPresentedModeFieldCodes.ID_COMMON_DATA_TEMPLATE, ConsumerPresentedModeDecoder.consumerTagLengthValue(CommonDataTemplate.class, ConsumerPresentedMode::setCommonDataTemplate));
        denyDuplicateTags.add(ConsumerPresentedModeFieldCodes.ID_PAYLOAD_FORMAT_INDICATOR);
        denyDuplicateTags.add(ConsumerPresentedModeFieldCodes.ID_COMMON_DATA_TEMPLATE);
    }
}

