/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.core.model.cpm;

import com.emv.qrcode.core.exception.DecodeValueException;
import com.emv.qrcode.core.model.cpm.BERTLV;
import com.emv.qrcode.core.model.cpm.BERTag;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class BERTLBinary
extends BERTLV {
    private static final long serialVersionUID = -2791656176543560953L;

    public BERTLBinary(BERTag tag, byte[] value) {
        super(tag, value);
    }

    public BERTLBinary(byte[] tag, byte[] value) {
        super(tag, value);
    }

    public BERTLBinary(byte[] tag, String value) {
        super(tag, StringUtils.isNotEmpty((CharSequence)value) ? BERTLBinary.toPrimitives(value) : EMPTY_BYTES);
    }

    public BERTLBinary(BERTag tag, String value) {
        super(tag, StringUtils.isNotEmpty((CharSequence)value) ? BERTLBinary.toPrimitives(value) : EMPTY_BYTES);
    }

    public final void setValue(String value) {
        this.setValue(StringUtils.isNotEmpty((CharSequence)value) ? BERTLBinary.toPrimitives(value) : EMPTY_BYTES);
    }

    private static byte[] toPrimitives(String value) {
        try {
            return Hex.decodeHex((String)value);
        }
        catch (DecoderException ex) {
            throw new DecodeValueException(value);
        }
    }

    @Override
    public String getStringValue() {
        return Hex.encodeHexString((byte[])this.value, (boolean)false);
    }
}

