/*
 * Decompiled with CFR 0.152.
 */
package moxy;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import moxy.MvpPresenter;

public class PresentersCounter {
    private Map<MvpPresenter<?>, Set<String>> connections = new HashMap();
    private Map<String, Set<MvpPresenter>> tags = new HashMap<String, Set<MvpPresenter>>();

    public void injectPresenter(MvpPresenter<?> presenter, String delegateTag) {
        Set<String> delegateTags = this.connections.get(presenter);
        if (delegateTags == null) {
            delegateTags = new HashSet<String>();
            this.connections.put(presenter, delegateTags);
        }
        delegateTags.add(delegateTag);
        Set<MvpPresenter> presenters = this.tags.get(delegateTag);
        if (presenters == null) {
            presenters = new HashSet<MvpPresenter>();
            this.tags.put(delegateTag, presenters);
        }
        presenters.add(presenter);
    }

    public boolean rejectPresenter(MvpPresenter<?> presenter, String delegateTag) {
        Set<String> delegateTags;
        Set<MvpPresenter> presenters = this.tags.get(delegateTag);
        if (presenters != null) {
            presenters.remove(presenter);
        }
        if (presenters == null || presenters.isEmpty()) {
            this.tags.remove(delegateTag);
        }
        if ((delegateTags = this.connections.get(presenter)) == null) {
            this.connections.remove(presenter);
            return true;
        }
        Iterator<String> tagsIterator = delegateTags.iterator();
        while (tagsIterator.hasNext()) {
            String tag = tagsIterator.next();
            if (!tag.startsWith(delegateTag)) continue;
            tagsIterator.remove();
        }
        boolean noTags = delegateTags.isEmpty();
        if (noTags) {
            this.connections.remove(presenter);
        }
        return noTags;
    }

    public Set<MvpPresenter> getAll(String delegateTag) {
        HashSet<MvpPresenter> presenters = new HashSet<MvpPresenter>();
        for (Map.Entry<String, Set<MvpPresenter>> tagsWithPresenters : this.tags.entrySet()) {
            if (!tagsWithPresenters.getKey().startsWith(delegateTag)) continue;
            presenters.addAll((Collection<MvpPresenter>)tagsWithPresenters.getValue());
        }
        return presenters;
    }

    public boolean isInjected(MvpPresenter<?> presenter) {
        Set<String> mDelegateTags = this.connections.get(presenter);
        return mDelegateTags != null && !mDelegateTags.isEmpty();
    }
}

