/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.util.List;
import java.util.Vector;
import javapns.devices.Device;
import javapns.notification.Payload;
import javapns.notification.ResponsePacket;
import javapns.notification.exceptions.ErrorResponsePacketReceivedException;

public class PushedNotification {
    private Payload payload;
    private Device device;
    private ResponsePacket response;
    private int identifier;
    private long expiry;
    private int transmissionAttempts;
    private boolean transmissionCompleted;
    private Exception exception;

    protected PushedNotification(Device device, Payload payload) {
        this.device = device;
        this.payload = payload;
    }

    PushedNotification(Device device, Payload payload, int identifier) {
        this.device = device;
        this.payload = payload;
        this.identifier = identifier;
    }

    public PushedNotification(Device device, Payload payload, Exception exception) {
        this.device = device;
        this.payload = payload;
        this.exception = exception;
    }

    public static List<PushedNotification> findSuccessfulNotifications(List<PushedNotification> notifications) {
        Vector<PushedNotification> filteredList = new Vector<PushedNotification>();
        for (PushedNotification notification : notifications) {
            if (!notification.isSuccessful()) continue;
            filteredList.add(notification);
        }
        return filteredList;
    }

    public static List<PushedNotification> findFailedNotifications(List<PushedNotification> notifications) {
        Vector<PushedNotification> filteredList = new Vector<PushedNotification>();
        for (PushedNotification notification : notifications) {
            if (notification.isSuccessful()) continue;
            filteredList.add(notification);
        }
        return filteredList;
    }

    public Payload getPayload() {
        return this.payload;
    }

    protected void setPayload(Payload payload) {
        this.payload = payload;
    }

    public Device getDevice() {
        return this.device;
    }

    protected void setDevice(Device device) {
        this.device = device;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public long getExpiry() {
        return this.expiry;
    }

    void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    void addTransmissionAttempt() {
        ++this.transmissionAttempts;
    }

    public int getTransmissionAttempts() {
        return this.transmissionAttempts;
    }

    void setTransmissionAttempts(int transmissionAttempts) {
        this.transmissionAttempts = transmissionAttempts;
    }

    public String getLatestTransmissionAttempt() {
        if (this.transmissionAttempts == 0) {
            return "no attempt yet";
        }
        switch (this.transmissionAttempts) {
            case 1: {
                return "first attempt";
            }
            case 2: {
                return "second attempt";
            }
            case 3: {
                return "third attempt";
            }
            case 4: {
                return "fourth attempt";
            }
        }
        return "attempt #" + this.transmissionAttempts;
    }

    public boolean isTransmissionCompleted() {
        return this.transmissionCompleted;
    }

    void setTransmissionCompleted(boolean completed) {
        this.transmissionCompleted = completed;
    }

    public ResponsePacket getResponse() {
        return this.response;
    }

    void setResponse(ResponsePacket response) {
        this.response = response;
        if (response != null && this.exception == null) {
            this.exception = new ErrorResponsePacketReceivedException(response);
        }
    }

    public boolean isSuccessful() {
        if (!this.transmissionCompleted) {
            return false;
        }
        if (this.response == null) {
            return true;
        }
        return !this.response.isValidErrorMessage();
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("[").append(this.identifier).append("]");
        msg.append(this.transmissionCompleted ? " transmitted " + this.payload + " on " + this.getLatestTransmissionAttempt() : " not transmitted");
        msg.append(" to token ").append(this.device.getToken().substring(0, 5)).append("..").append(this.device.getToken().substring(59, 64));
        if (this.response != null) {
            msg.append("  ").append(this.response.getMessage());
        }
        if (this.exception != null) {
            msg.append("  ").append(this.exception);
        }
        return msg.toString();
    }

    public Exception getException() {
        return this.exception;
    }

    void setException(Exception exception) {
        this.exception = exception;
    }
}

