/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.recaptcha.security.login;

import com.github.mkopylec.recaptcha.RecaptchaProperties;
import com.github.mkopylec.recaptcha.security.login.LoginFailuresManager;
import com.github.mkopylec.recaptcha.security.login.RecaptchaAwareRedirectStrategy;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class LoginFailuresCountingHandler
extends SimpleUrlAuthenticationFailureHandler {
    protected final LoginFailuresManager failuresManager;

    public LoginFailuresCountingHandler(LoginFailuresManager failuresManager, RecaptchaProperties recaptcha, RecaptchaAwareRedirectStrategy redirectStrategy) {
        this.failuresManager = failuresManager;
        this.setDefaultFailureUrl(recaptcha.getSecurity().getFailureUrl());
        this.setRedirectStrategy((RedirectStrategy)redirectStrategy);
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.failuresManager.addLoginFailure(request);
        super.onAuthenticationFailure(request, response, exception);
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        if (!RecaptchaAwareRedirectStrategy.class.isAssignableFrom(redirectStrategy.getClass())) {
            throw new IllegalArgumentException("Invalid redirect strategy. Redirect strategy must be an instance of " + RecaptchaAwareRedirectStrategy.class.getName() + " but is " + redirectStrategy);
        }
        super.setRedirectStrategy(redirectStrategy);
    }
}

