/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.recaptcha.security.login;

import com.github.mkopylec.recaptcha.RecaptchaProperties;
import com.github.mkopylec.recaptcha.security.login.LoginFailuresManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryLoginFailuresManager
extends LoginFailuresManager {
    private static final Logger log = LoggerFactory.getLogger(InMemoryLoginFailuresManager.class);
    protected final ConcurrentMap<String, Integer> loginFailures = new ConcurrentHashMap<String, Integer>();

    public InMemoryLoginFailuresManager(RecaptchaProperties recaptcha) {
        super(recaptcha);
    }

    @Override
    public void addLoginFailure(HttpServletRequest request) {
        String username = this.getUsername(request);
        log.debug("Adding login failure for username: {}", (Object)username);
        this.loginFailures.compute(username, (name, count) -> count == null ? 1 : count + 1);
    }

    @Override
    public int getLoginFailuresCount(HttpServletRequest request) {
        String username = this.getUsername(request);
        int count = this.loginFailures.getOrDefault(username, 0);
        log.debug("Getting login failures count: {} for username: {}", (Object)count, (Object)username);
        return count;
    }

    @Override
    public void clearLoginFailures(HttpServletRequest request) {
        String username = this.getUsername(request);
        log.debug("Clearing login failures for username: {}", (Object)username);
        this.loginFailures.remove(username);
    }
}

