/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.recaptcha;

import com.github.mkopylec.recaptcha.validation.ErrorCode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="recaptcha")
public class RecaptchaProperties {
    private Validation validation = new Validation();
    private Security security = new Security();
    private Testing testing = new Testing();

    public Validation getValidation() {
        return this.validation;
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public Testing getTesting() {
        return this.testing;
    }

    public void setTesting(Testing testing) {
        this.testing = testing;
    }

    public static class Testing {
        private boolean enabled = false;
        private boolean successResult = true;
        private List<ErrorCode> resultErrorCodes = new ArrayList<ErrorCode>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isSuccessResult() {
            return this.successResult;
        }

        public void setSuccessResult(boolean successResult) {
            this.successResult = successResult;
        }

        public List<ErrorCode> getResultErrorCodes() {
            return this.resultErrorCodes;
        }

        public void setResultErrorCodes(List<ErrorCode> resultErrorCodes) {
            this.resultErrorCodes = resultErrorCodes;
        }
    }

    public static class Security {
        private String failureUrl = "/login";
        private int loginFailuresThreshold = 5;
        private boolean continueOnValidationHttpError = true;

        public String getFailureUrl() {
            return this.failureUrl;
        }

        public void setFailureUrl(String failureUrl) {
            this.failureUrl = failureUrl;
        }

        public int getLoginFailuresThreshold() {
            return this.loginFailuresThreshold;
        }

        public void setLoginFailuresThreshold(int loginFailuresThreshold) {
            this.loginFailuresThreshold = loginFailuresThreshold;
        }

        public boolean isContinueOnValidationHttpError() {
            return this.continueOnValidationHttpError;
        }

        public void setContinueOnValidationHttpError(boolean continueOnValidationHttpError) {
            this.continueOnValidationHttpError = continueOnValidationHttpError;
        }
    }

    public static class Validation {
        private String secretKey;
        private String responseParameter = "g-recaptcha-response";
        private String verificationUrl = "https://www.google.com/recaptcha/api/siteverify";
        private Timeout timeout = new Timeout();

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getResponseParameter() {
            return this.responseParameter;
        }

        public void setResponseParameter(String responseParameter) {
            this.responseParameter = responseParameter;
        }

        public String getVerificationUrl() {
            return this.verificationUrl;
        }

        public void setVerificationUrl(String verificationUrl) {
            this.verificationUrl = verificationUrl;
        }

        public Timeout getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Timeout timeout) {
            this.timeout = timeout;
        }

        public static class Timeout {
            private Duration connect = Duration.ofMillis(500L);
            private Duration read = Duration.ofMillis(1000L);
            private Duration write = Duration.ofMillis(1000L);

            public Duration getConnect() {
                return this.connect;
            }

            public void setConnect(Duration connect) {
                this.connect = connect;
            }

            public Duration getRead() {
                return this.read;
            }

            public void setRead(Duration read) {
                this.read = read;
            }

            public Duration getWrite() {
                return this.write;
            }

            public void setWrite(Duration write) {
                this.write = write;
            }
        }
    }
}

