/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.assertions;

import com.github.mkolisnyk.cucumber.assertions.LazyAssertionError;
import com.github.mkolisnyk.cucumber.assertions.MatcherLazyAssert;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.junit.ComparisonFailure;
import org.junit.internal.ArrayComparisonFailure;
import org.junit.internal.ExactComparisonCriteria;
import org.junit.internal.InexactComparisonCriteria;

public final class LazyAssert {
    private LazyAssert() {
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            LazyAssert.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        LazyAssert.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        LazyAssert.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        LazyAssert.assertFalse(null, condition);
    }

    public static void fail(String message) {
        if (message == null) {
            throw new LazyAssertionError();
        }
        throw new LazyAssertionError(message);
    }

    public static void fail() {
        LazyAssert.fail(null);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (LazyAssert.equalsRegardingNull(expected, actual)) {
            return;
        }
        if (expected instanceof String && actual instanceof String) {
            String cleanMessage = "";
            if (StringUtils.isNotBlank((CharSequence)message)) {
                cleanMessage = message;
            }
            throw new ComparisonFailure(cleanMessage, (String)expected, (String)actual);
        }
        LazyAssert.failNotEquals(message, expected, actual);
    }

    private static boolean equalsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return LazyAssert.isEquals(expected, actual);
    }

    private static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        LazyAssert.assertEquals(null, expected, actual);
    }

    public static void assertNotEquals(String message, Object unexpected, Object actual) {
        if (LazyAssert.equalsRegardingNull(unexpected, actual)) {
            LazyAssert.failEquals(message, actual);
        }
    }

    public static void assertNotEquals(Object unexpected, Object actual) {
        LazyAssert.assertNotEquals(null, unexpected, actual);
    }

    private static void failEquals(String message, Object actual) {
        String formatted = "Values should be different. ";
        if (message != null) {
            formatted = message + ". ";
        }
        formatted = formatted + "Actual: " + actual;
        LazyAssert.fail(formatted);
    }

    public static void assertNotEquals(String message, long unexpected, long actual) {
        if (unexpected == actual) {
            LazyAssert.failEquals(message, actual);
        }
    }

    public static void assertNotEquals(long unexpected, long actual) {
        LazyAssert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(String message, double unexpected, double actual, double delta) {
        if (!LazyAssert.doubleIsDifferent(unexpected, actual, delta)) {
            LazyAssert.failEquals(message, actual);
        }
    }

    public static void assertNotEquals(double unexpected, double actual, double delta) {
        LazyAssert.assertNotEquals(null, unexpected, actual, delta);
    }

    public static void assertNotEquals(float unexpected, float actual, float delta) {
        LazyAssert.assertNotEquals(null, unexpected, actual, delta);
    }

    public static void assertArrayEquals(String message, Object[] expecteds, Object[] actuals) throws ArrayComparisonFailure {
        LazyAssert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        LazyAssert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, boolean[] expecteds, boolean[] actuals) throws ArrayComparisonFailure {
        LazyAssert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(boolean[] expecteds, boolean[] actuals) {
        LazyAssert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, byte[] expecteds, byte[] actuals) throws ArrayComparisonFailure {
        LazyAssert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(byte[] expecteds, byte[] actuals) {
        LazyAssert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, char[] expecteds, char[] actuals) throws ArrayComparisonFailure {
        LazyAssert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(char[] expecteds, char[] actuals) {
        LazyAssert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, short[] expecteds, short[] actuals) throws ArrayComparisonFailure {
        LazyAssert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(short[] expecteds, short[] actuals) {
        LazyAssert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, int[] expecteds, int[] actuals) throws ArrayComparisonFailure {
        LazyAssert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(int[] expecteds, int[] actuals) {
        LazyAssert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, long[] expecteds, long[] actuals) throws ArrayComparisonFailure {
        LazyAssert.internalArrayEquals(message, expecteds, actuals);
    }

    public static void assertArrayEquals(long[] expecteds, long[] actuals) {
        LazyAssert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message, double[] expecteds, double[] actuals, double delta) throws ArrayComparisonFailure {
        try {
            new InexactComparisonCriteria(delta).arrayEquals(message, (Object)expecteds, (Object)actuals);
        }
        catch (AssertionError e) {
            throw new LazyAssertionError(message, (Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(double[] expecteds, double[] actuals, double delta) {
        LazyAssert.assertArrayEquals(null, expecteds, actuals, delta);
    }

    public static void assertArrayEquals(String message, float[] expecteds, float[] actuals, float delta) throws ArrayComparisonFailure {
        try {
            new InexactComparisonCriteria(delta).arrayEquals(message, (Object)expecteds, (Object)actuals);
        }
        catch (AssertionError e) {
            throw new LazyAssertionError(message, (Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(float[] expecteds, float[] actuals, float delta) {
        LazyAssert.assertArrayEquals(null, expecteds, actuals, delta);
    }

    private static void internalArrayEquals(String message, Object expecteds, Object actuals) throws ArrayComparisonFailure {
        try {
            new ExactComparisonCriteria().arrayEquals(message, expecteds, actuals);
        }
        catch (AssertionError e) {
            throw new LazyAssertionError(message, (Throwable)((Object)e));
        }
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (LazyAssert.doubleIsDifferent(expected, actual, delta)) {
            LazyAssert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        if (LazyAssert.floatIsDifferent(expected, actual, delta)) {
            LazyAssert.failNotEquals(message, Float.valueOf(expected), Float.valueOf(actual));
        }
    }

    public static void assertNotEquals(String message, float unexpected, float actual, float delta) {
        if (!LazyAssert.floatIsDifferent(unexpected, actual, delta)) {
            LazyAssert.failEquals(message, Float.valueOf(actual));
        }
    }

    private static boolean doubleIsDifferent(double d1, double d2, double delta) {
        if (Double.compare(d1, d2) == 0) {
            return false;
        }
        return !(Math.abs(d1 - d2) <= delta);
    }

    private static boolean floatIsDifferent(float f1, float f2, float delta) {
        if (Float.compare(f1, f2) == 0) {
            return false;
        }
        return !(Math.abs(f1 - f2) <= delta);
    }

    public static void assertEquals(long expected, long actual) {
        LazyAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, long expected, long actual) {
        if (expected != actual) {
            LazyAssert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        LazyAssert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        LazyAssert.assertEquals(null, expected, actual, delta);
    }

    public static void assertNotNull(String message, Object object) {
        LazyAssert.assertTrue(message, object != null);
    }

    public static void assertNotNull(Object object) {
        LazyAssert.assertNotNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        if (object == null) {
            return;
        }
        LazyAssert.failNotNull(message, object);
    }

    public static void assertNull(Object object) {
        LazyAssert.assertNull(null, object);
    }

    private static void failNotNull(String message, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        LazyAssert.fail(formatted + "expected null, but was:<" + actual + ">");
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        LazyAssert.failNotSame(message, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        LazyAssert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object unexpected, Object actual) {
        if (unexpected == actual) {
            LazyAssert.failSame(message);
        }
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        LazyAssert.assertNotSame(null, unexpected, actual);
    }

    private static void failSame(String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        LazyAssert.fail(formatted + "expected not same");
    }

    private static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        LazyAssert.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        LazyAssert.fail(LazyAssert.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = message + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return formatted + "expected: " + LazyAssert.formatClassAndValue(expected, expectedString) + " but was: " + LazyAssert.formatClassAndValue(actual, actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = "null";
        if (value != null) {
            className = value.getClass().getName();
        }
        return className + "<" + valueString + ">";
    }

    @Deprecated
    public static void assertEquals(String message, Object[] expecteds, Object[] actuals) {
        LazyAssert.assertArrayEquals(message, expecteds, actuals);
    }

    @Deprecated
    public static void assertEquals(Object[] expecteds, Object[] actuals) {
        LazyAssert.assertArrayEquals(expecteds, actuals);
    }

    public static <T> void assertThat(T actual, Matcher<? super T> matcher) {
        LazyAssert.assertThat("", actual, matcher);
    }

    public static <T> void assertThat(String reason, T actual, Matcher<? super T> matcher) {
        MatcherLazyAssert.assertThat(reason, actual, matcher);
    }
}

