/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.process.executor;

import com.thebuzzmedia.exiftool.commons.io.IOs;
import com.thebuzzmedia.exiftool.commons.lang.Objects;
import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.CommandProcess;
import com.thebuzzmedia.exiftool.process.OutputHandler;
import com.thebuzzmedia.exiftool.process.executor.CompositeHandler;
import com.thebuzzmedia.exiftool.process.executor.ResultHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class DefaultCommandProcess
implements CommandProcess {
    private static final Logger log = LoggerFactory.getLogger(DefaultCommandProcess.class);
    private final InputStream is;
    private final OutputStream os;
    private final InputStream err;
    private boolean close;

    public DefaultCommandProcess(InputStream is, OutputStream os, InputStream err) {
        this.is = java.util.Objects.requireNonNull(is, "Input stream should not be null");
        this.os = java.util.Objects.requireNonNull(os, "Output stream should not be null");
        this.err = java.util.Objects.requireNonNull(err, "Error stream should not be null");
        this.close = false;
    }

    @Override
    public String read() throws IOException {
        return this.doRead(null);
    }

    @Override
    public String read(OutputHandler handler) throws IOException {
        return this.doRead(java.util.Objects.requireNonNull(handler, "Handler should not be null"));
    }

    @Override
    public void write(String input, String ... others) throws IOException {
        this.doWrite(input);
        for (String o : others) {
            this.doWrite(o);
        }
    }

    @Override
    public void write(Iterable<String> inputs) throws IOException {
        PreConditions.notEmpty(inputs, "Write inputs should not be empty");
        for (String input : inputs) {
            this.doWrite(input);
        }
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public boolean isRunning() {
        return !this.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.close;
    }

    @Override
    public void close() throws Exception {
        IOException ex1 = this.close(this.os);
        IOException ex2 = this.close(this.is);
        IOException ex3 = this.close(this.err);
        this.close = true;
        if (ex1 != null || ex2 != null || ex3 != null) {
            throw Objects.firstNonNull(ex1, ex2, ex3);
        }
    }

    private IOException close(Closeable closeable) {
        try {
            closeable.close();
            return null;
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), ex);
            return ex;
        }
    }

    private String doRead(OutputHandler h) throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot read from closed process");
        }
        log.debug("Read command output");
        ResultHandler out = new ResultHandler();
        OutputHandler handler = h == null ? out : new CompositeHandler(out, h);
        IOs.readInputStream(this.is, handler);
        return out.getOutput();
    }

    private void doWrite(String input) throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot write from closed process");
        }
        java.util.Objects.requireNonNull(input, "Write input should not be null");
        Charset charset = this.guessCharset();
        log.debug("Send command input with charset {}: {}", charset, input);
        try {
            this.os.write(input.getBytes(charset));
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), ex);
            throw ex;
        }
    }

    private Charset guessCharset() {
        String nativeEncoding = System.getProperty("native.encoding");
        if (nativeEncoding != null) {
            return Charset.forName(nativeEncoding);
        }
        String fileEncoding = System.getProperty("file.encoding");
        if (fileEncoding != null) {
            return Charset.forName(fileEncoding);
        }
        return StandardCharsets.UTF_8;
    }
}

