/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.strategies;

import com.thebuzzmedia.exiftool.Constants;
import com.thebuzzmedia.exiftool.ExecutionStrategy;
import com.thebuzzmedia.exiftool.Scheduler;
import com.thebuzzmedia.exiftool.Version;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import com.thebuzzmedia.exiftool.process.CommandProcess;
import com.thebuzzmedia.exiftool.process.OutputHandler;
import com.thebuzzmedia.exiftool.process.command.CommandBuilder;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class StayOpenStrategy
implements ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(StayOpenStrategy.class);
    private static final Version V8_36 = new Version("8.36");
    private final Scheduler scheduler;
    private CommandProcess process;

    public StayOpenStrategy(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandExecutor executor, String exifTool, List<String> arguments, OutputHandler handler) throws IOException {
        log.debug("Using ExifTool in daemon mode (-stay_open True)...");
        List<String> newArgs = arguments.stream().map(input -> input + Constants.BR).collect(Collectors.toList());
        StayOpenStrategy stayOpenStrategy = this;
        synchronized (stayOpenStrategy) {
            if (this.process == null || this.process.isClosed()) {
                log.debug("Start exiftool process");
                this.process = executor.start(CommandBuilder.builder(exifTool, 6).addArgument("-stay_open", "True").addArgument("-sep", "|>\u2603").addArgument("-@", new String[0]).addArgument("-", new String[0]).build());
            }
            this.scheduler.stop();
            this.scheduler.start(this::safeClose);
            try {
                this.process.write(newArgs);
                this.process.flush();
                this.process.read(handler);
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), ex);
                throw ex;
            }
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return this.process != null && this.process.isRunning();
    }

    @Override
    public boolean isSupported(Version version) {
        return V8_36.compareTo(version) <= 0;
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.process != null) {
            this.closeProcess();
        }
        this.closeScheduler();
    }

    @Override
    public synchronized void shutdown() throws Exception {
        this.close();
        this.shutdownScheduler();
    }

    private synchronized void closeScheduler() {
        try {
            log.debug("Attempting to stop cleanup task");
            this.scheduler.stop();
            log.debug("Cleanup task successfully stopped");
        }
        catch (Exception ex) {
            log.warn("Cleanup task failed to stop");
            log.warn(ex.getMessage(), ex);
        }
    }

    private synchronized void shutdownScheduler() {
        try {
            log.debug("Attempting to shutdown cleanup task");
            this.scheduler.shutdown();
            log.debug("Cleanup task successfully shutdown");
        }
        catch (Exception ex) {
            log.warn("Cleanup task failed to shutdown");
            log.warn(ex.getMessage(), ex);
        }
    }

    private synchronized void closeProcess() throws Exception {
        try {
            log.debug("Attempting to close ExifTool daemon process, issuing '-stay_open\\nFalse\\n' command...");
            this.process.write("-stay_open\nFalse\n", new String[0]);
            this.process.flush();
            this.process.close();
            log.debug("ExifTool daemon process successfully closed");
        }
        catch (Exception ex) {
            log.warn("ExifTool daemon failed to stop");
            log.warn(ex.getMessage(), ex);
            throw ex;
        }
        finally {
            this.process = null;
        }
    }

    private synchronized void safeClose() {
        try {
            this.close();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
    }
}

