/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.lang;

import java.util.ArrayList;
import java.util.List;

public class ToStringBuilder {
    private static final String OBJECT_START = "{";
    private static final String OBJECT_END = "}";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String NULL_VALUE = "null";
    private static final String KEY_VALUE_SEPARATOR = ": ";
    private static final String FIELD_SEPARATOR = ", ";
    private final Class<?> klass;
    private final List<String> fields;
    private int size;

    public static ToStringBuilder create(Class<?> klass) {
        return new ToStringBuilder(klass);
    }

    private ToStringBuilder(Class<?> klass) {
        this.klass = klass;
        this.size = 0;
        this.fields = new ArrayList<String>();
    }

    public ToStringBuilder append(String name, String value) {
        String val = value == null ? NULL_VALUE : DOUBLE_QUOTE + value + DOUBLE_QUOTE;
        return this.appendValue(name, val);
    }

    public ToStringBuilder append(String name, long value) {
        return this.appendValue(name, String.valueOf(value));
    }

    public ToStringBuilder append(String name, Object object) {
        String value = object == null ? NULL_VALUE : object.toString();
        return this.appendValue(name, value);
    }

    private ToStringBuilder appendValue(String name, CharSequence value) {
        String formattedValue = name + KEY_VALUE_SEPARATOR + value;
        this.fields.add(formattedValue);
        this.size += formattedValue.length();
        return this;
    }

    public String build() {
        String klassName = this.klass.getSimpleName();
        String formattedFields = this.joinFields();
        int fullSize = klassName.length() + formattedFields.length() + 2;
        return new StringBuilder(fullSize).append(klassName).append(OBJECT_START).append(formattedFields).append(OBJECT_END).toString();
    }

    private String joinFields() {
        int fullSize = this.size + this.fields.size() * FIELD_SEPARATOR.length();
        StringBuilder sb = new StringBuilder(fullSize);
        boolean first = true;
        for (String field : this.fields) {
            if (!first) {
                sb.append(FIELD_SEPARATOR);
            }
            sb.append(field);
            first = false;
        }
        return sb.toString();
    }
}

