/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.util.Log;
import com.github.mjdev.libaums.usb.AndroidUsbCommunication;
import com.github.mjdev.libaums.usb.HoneyCombMr1Communication;
import com.github.mjdev.libaums.usb.JellyBeanMr2Communication;
import com.github.mjdev.libaums.usb.UsbCommunication;
import com.github.mjdev.libaums.usb.UsbRequestCommunication;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/github/mjdev/libaums/usb/UsbCommunicationFactory;", "", "()V", "TAG", "", "underlyingUsbCommunication", "Lcom/github/mjdev/libaums/usb/UsbCommunicationFactory$UnderlyingUsbCommunication;", "underlyingUsbCommunication$annotations", "getUnderlyingUsbCommunication", "()Lcom/github/mjdev/libaums/usb/UsbCommunicationFactory$UnderlyingUsbCommunication;", "setUnderlyingUsbCommunication", "(Lcom/github/mjdev/libaums/usb/UsbCommunicationFactory$UnderlyingUsbCommunication;)V", "createUsbCommunication", "Lcom/github/mjdev/libaums/usb/UsbCommunication;", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "UnderlyingUsbCommunication", "libaums_release"})
public final class UsbCommunicationFactory {
    private static final String TAG;
    @NotNull
    private static UnderlyingUsbCommunication underlyingUsbCommunication;
    public static final UsbCommunicationFactory INSTANCE;

    @JvmStatic
    public static /* synthetic */ void underlyingUsbCommunication$annotations() {
    }

    @NotNull
    public static final UnderlyingUsbCommunication getUnderlyingUsbCommunication() {
        return underlyingUsbCommunication;
    }

    public static final void setUnderlyingUsbCommunication(@NotNull UnderlyingUsbCommunication underlyingUsbCommunication) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)underlyingUsbCommunication), (String)"<set-?>");
        UsbCommunicationFactory.underlyingUsbCommunication = underlyingUsbCommunication;
    }

    @NotNull
    public final UsbCommunication createUsbCommunication(@NotNull UsbManager usbManager, @NotNull UsbDevice usbDevice, @NotNull UsbInterface usbInterface, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        UsbCommunication usbCommunication;
        Intrinsics.checkParameterIsNotNull((Object)usbManager, (String)"usbManager");
        Intrinsics.checkParameterIsNotNull((Object)usbDevice, (String)"usbDevice");
        Intrinsics.checkParameterIsNotNull((Object)usbInterface, (String)"usbInterface");
        Intrinsics.checkParameterIsNotNull((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkParameterIsNotNull((Object)inEndpoint, (String)"inEndpoint");
        if (underlyingUsbCommunication == UnderlyingUsbCommunication.DEVICE_CONNECTION_SYNC) {
            AndroidUsbCommunication androidUsbCommunication;
            if (Build.VERSION.SDK_INT >= 18) {
                androidUsbCommunication = new JellyBeanMr2Communication(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
            } else {
                Log.i((String)TAG, (String)"using workaround usb communication");
                androidUsbCommunication = new HoneyCombMr1Communication(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
            }
            usbCommunication = androidUsbCommunication;
        } else {
            usbCommunication = new UsbRequestCommunication(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
        }
        return usbCommunication;
    }

    private UsbCommunicationFactory() {
    }

    static {
        UsbCommunicationFactory usbCommunicationFactory;
        INSTANCE = usbCommunicationFactory = new UsbCommunicationFactory();
        String string = UsbCommunicationFactory.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UsbCommunicationFactory::class.java.simpleName");
        TAG = string;
        underlyingUsbCommunication = UnderlyingUsbCommunication.DEVICE_CONNECTION_SYNC;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/github/mjdev/libaums/usb/UsbCommunicationFactory$UnderlyingUsbCommunication;", "", "(Ljava/lang/String;I)V", "USB_REQUEST_ASYNC", "DEVICE_CONNECTION_SYNC", "libaums_release"})
    public static final class UnderlyingUsbCommunication
    extends Enum<UnderlyingUsbCommunication> {
        public static final /* enum */ UnderlyingUsbCommunication USB_REQUEST_ASYNC;
        public static final /* enum */ UnderlyingUsbCommunication DEVICE_CONNECTION_SYNC;
        private static final /* synthetic */ UnderlyingUsbCommunication[] $VALUES;

        static {
            UnderlyingUsbCommunication[] underlyingUsbCommunicationArray = new UnderlyingUsbCommunication[2];
            UnderlyingUsbCommunication[] underlyingUsbCommunicationArray2 = underlyingUsbCommunicationArray;
            underlyingUsbCommunicationArray[0] = USB_REQUEST_ASYNC = new UnderlyingUsbCommunication();
            underlyingUsbCommunicationArray[1] = DEVICE_CONNECTION_SYNC = new UnderlyingUsbCommunication();
            $VALUES = underlyingUsbCommunicationArray;
        }

        public static UnderlyingUsbCommunication[] values() {
            return (UnderlyingUsbCommunication[])$VALUES.clone();
        }

        public static UnderlyingUsbCommunication valueOf(String string) {
            return Enum.valueOf(UnderlyingUsbCommunication.class, string);
        }
    }
}

