/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.AbstractUsbFile;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.fat32.ClusterChain;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.Fat32FileSystem;
import com.github.mjdev.libaums.fs.fat32.FatDirectoryEntry;
import com.github.mjdev.libaums.fs.fat32.FatFile;
import com.github.mjdev.libaums.fs.fat32.FatLfnDirectoryEntry;
import com.github.mjdev.libaums.fs.fat32.ShortName;
import com.github.mjdev.libaums.fs.fat32.ShortNameGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 S2\u00020\u0001:\u0001SB;\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\rJ\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020-H\u0002J\b\u00104\u001a\u000202H\u0016J\u0010\u00105\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u00106\u001a\u0002072\u0006\u0010\"\u001a\u00020 H\u0016J\b\u00108\u001a\u00020\u0018H\u0016J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u000202H\u0016J\b\u0010;\u001a\u000202H\u0002J\b\u0010<\u001a\u00020\u0018H\u0016J\b\u0010=\u001a\u00020\u0018H\u0016J\u0013\u0010>\u001a\b\u0012\u0004\u0012\u00020 0?H\u0016\u00a2\u0006\u0002\u0010@J\u0013\u0010A\u001a\b\u0012\u0004\u0012\u00020B0?H\u0016\u00a2\u0006\u0002\u0010CJ\u001d\u0010D\u001a\u0002022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020BH\u0000\u00a2\u0006\u0002\bFJ\u0010\u0010G\u001a\u0002022\u0006\u0010E\u001a\u00020BH\u0016J\u0018\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020\u00182\u0006\u0010E\u001a\u00020JH\u0016J\b\u0010K\u001a\u000202H\u0002J\u0017\u0010L\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\bMJ\u001f\u0010N\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020 H\u0000\u00a2\u0006\u0002\bOJ\r\u0010P\u001a\u000202H\u0000\u00a2\u0006\u0002\bQJ\u0018\u0010P\u001a\u0002022\u0006\u0010I\u001a\u00020\u00182\u0006\u0010R\u001a\u00020JH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000b0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020 8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010/\u001a\u0004\u0018\u00010 2\b\u0010.\u001a\u0004\u0018\u00010 @BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010$\u00a8\u0006T"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/FatDirectory;", "Lcom/github/mjdev/libaums/fs/AbstractUsbFile;", "fs", "Lcom/github/mjdev/libaums/fs/fat32/Fat32FileSystem;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "fat", "Lcom/github/mjdev/libaums/fs/fat32/FAT;", "bootSector", "Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;", "entry", "Lcom/github/mjdev/libaums/fs/fat32/FatLfnDirectoryEntry;", "parent", "(Lcom/github/mjdev/libaums/fs/fat32/Fat32FileSystem;Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;Lcom/github/mjdev/libaums/fs/fat32/FAT;Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;Lcom/github/mjdev/libaums/fs/fat32/FatLfnDirectoryEntry;Lcom/github/mjdev/libaums/fs/fat32/FatDirectory;)V", "chain", "Lcom/github/mjdev/libaums/fs/fat32/ClusterChain;", "entries", "", "hasBeenInited", "", "isDirectory", "()Z", "isRoot", "<anonymous parameter 0>", "", "length", "getLength", "()J", "setLength", "(J)V", "lfnMap", "", "", "newName", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getParent", "()Lcom/github/mjdev/libaums/fs/fat32/FatDirectory;", "setParent", "(Lcom/github/mjdev/libaums/fs/fat32/FatDirectory;)V", "shortNameMap", "Lcom/github/mjdev/libaums/fs/fat32/ShortName;", "Lcom/github/mjdev/libaums/fs/fat32/FatDirectoryEntry;", "<set-?>", "volumeLabel", "getVolumeLabel$libaums_release", "addEntry", "", "lfnEntry", "close", "createDirectory", "createFile", "Lcom/github/mjdev/libaums/fs/fat32/FatFile;", "createdAt", "delete", "flush", "init", "lastAccessed", "lastModified", "list", "", "()[Ljava/lang/String;", "listFiles", "Lcom/github/mjdev/libaums/fs/UsbFile;", "()[Lcom/github/mjdev/libaums/fs/UsbFile;", "move", "destination", "move$libaums_release", "moveTo", "read", "offset", "Ljava/nio/ByteBuffer;", "readEntries", "removeEntry", "removeEntry$libaums_release", "renameEntry", "renameEntry$libaums_release", "write", "write$libaums_release", "source", "Companion", "libaums_release"})
public final class FatDirectory
extends AbstractUsbFile {
    private ClusterChain chain;
    private List<FatLfnDirectoryEntry> entries;
    private final Map<String, FatLfnDirectoryEntry> lfnMap;
    private final Map<ShortName, FatDirectoryEntry> shortNameMap;
    @Nullable
    private String volumeLabel;
    private boolean hasBeenInited;
    private final Fat32FileSystem fs;
    private final BlockDeviceDriver blockDevice;
    private final FAT fat;
    private final Fat32BootSector bootSector;
    private FatLfnDirectoryEntry entry;
    @Nullable
    private FatDirectory parent;
    private static final String TAG;
    public static final Companion Companion;

    @Nullable
    public final String getVolumeLabel$libaums_release() {
        return this.volumeLabel;
    }

    @Override
    public boolean isRoot() {
        return this.entry == null;
    }

    @Override
    public long getLength() {
        throw (Throwable)new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void setLength(long $noName_0) {
        throw (Throwable)new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string;
        if (this.entry != null) {
            FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
            if (fatLfnDirectoryEntry == null) {
                Intrinsics.throwNpe();
            }
            string = fatLfnDirectoryEntry.getName$libaums_release();
        } else {
            string = "/";
        }
        return string;
    }

    @Override
    public void setName(@NotNull String newName) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        boolean bl = !this.isRoot();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot rename root dir!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        FatDirectory fatDirectory = this.getParent();
        if (fatDirectory == null) {
            Intrinsics.throwNpe();
        }
        fatDirectory.renameEntry$libaums_release(this.entry, newName);
    }

    private final void init() throws IOException {
        if (this.chain == null) {
            FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
            if (fatLfnDirectoryEntry == null) {
                Intrinsics.throwNpe();
            }
            this.chain = new ClusterChain(fatLfnDirectoryEntry.getStartCluster(), this.blockDevice, this.fat, this.bootSector);
        }
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        List<FatLfnDirectoryEntry> list = this.entries;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        if (list.size() == 0 && !this.hasBeenInited) {
            this.readEntries();
        }
        this.hasBeenInited = true;
    }

    private final void readEntries() throws IOException {
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)clusterChain.getLength$libaums_release());
        ClusterChain clusterChain2 = this.chain;
        if (clusterChain2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
        }
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        clusterChain2.read$libaums_release(0L, byteBuffer);
        ArrayList<FatDirectoryEntry> list = new ArrayList<FatDirectoryEntry>();
        buffer.flip();
        while (buffer.remaining() > 0) {
            FatDirectoryEntry e;
            if (FatDirectoryEntry.Companion.read(buffer) == null) {
                break;
            }
            if (e.isLfnEntry()) {
                list.add(e);
                continue;
            }
            if (e.isVolumeLabel()) {
                if (!this.isRoot()) {
                    Log.w((String)TAG, (String)"volume label in non root dir!");
                }
                this.volumeLabel = e.getVolumeLabel();
                StringBuilder stringBuilder = new StringBuilder().append("volume label: ");
                String string = this.volumeLabel;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Log.d((String)TAG, (String)stringBuilder.append(string).toString());
                continue;
            }
            if (e.isDeleted()) {
                list.clear();
                continue;
            }
            FatLfnDirectoryEntry lfnEntry = FatLfnDirectoryEntry.Companion.read(e, (List<FatDirectoryEntry>)list);
            this.addEntry(lfnEntry, e);
            list.clear();
        }
    }

    private final void addEntry(FatLfnDirectoryEntry lfnEntry, FatDirectoryEntry entry) {
        List<FatLfnDirectoryEntry> list = this.entries;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        list.add(lfnEntry);
        String string = lfnEntry.getName$libaums_release();
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        Map<String, FatLfnDirectoryEntry> map = this.lfnMap;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string4 = string3;
        map.put(string4, lfnEntry);
        ShortName shortName = entry.getShortName();
        if (shortName == null) {
            Intrinsics.throwNpe();
        }
        this.shortNameMap.put(shortName, entry);
    }

    public final void removeEntry$libaums_release(@Nullable FatLfnDirectoryEntry lfnEntry) {
        List<FatLfnDirectoryEntry> list = this.entries;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        Map<ShortName, FatDirectoryEntry> map = list;
        boolean bl = false;
        Collection collection = map;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection).remove(lfnEntry);
        FatLfnDirectoryEntry fatLfnDirectoryEntry = lfnEntry;
        if (fatLfnDirectoryEntry == null) {
            Intrinsics.throwNpe();
        }
        map = fatLfnDirectoryEntry.getName$libaums_release();
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Object object = locale;
        Map<String, FatLfnDirectoryEntry> map2 = this.lfnMap;
        boolean bl2 = false;
        Map<ShortName, FatDirectoryEntry> map3 = map;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)((Object)map3)).toLowerCase((Locale)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string2 = string;
        map2.remove(string2);
        map = this.shortNameMap;
        object = lfnEntry.getActualEntry().getShortName();
        bl2 = false;
        Map<ShortName, FatDirectoryEntry> map4 = map;
        if (map4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
        }
        TypeIntrinsics.asMutableMap(map4).remove(object);
    }

    public final void renameEntry$libaums_release(@Nullable FatLfnDirectoryEntry lfnEntry, @NotNull String newName) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        FatLfnDirectoryEntry fatLfnDirectoryEntry = lfnEntry;
        if (fatLfnDirectoryEntry == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)fatLfnDirectoryEntry.getName$libaums_release(), (Object)newName)) {
            return;
        }
        this.removeEntry$libaums_release(lfnEntry);
        lfnEntry.setName(newName, ShortNameGenerator.INSTANCE.generateShortName(newName, (Collection<ShortName>)this.shortNameMap.keySet()));
        this.addEntry(lfnEntry, lfnEntry.getActualEntry());
        this.write$libaums_release();
    }

    public final void write$libaums_release() throws IOException {
        this.init();
        boolean writeVolumeLabel = this.isRoot() && this.volumeLabel != null;
        int totalEntryCount = 0;
        List<FatLfnDirectoryEntry> list = this.entries;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (FatLfnDirectoryEntry entry : list) {
            totalEntryCount += entry.getEntryCount();
        }
        if (writeVolumeLabel) {
            ++totalEntryCount;
        }
        long totalBytes = totalEntryCount * 32;
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
        }
        clusterChain.setLength$libaums_release(totalBytes);
        ClusterChain clusterChain2 = this.chain;
        if (clusterChain2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)clusterChain2.getLength$libaums_release());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (writeVolumeLabel) {
            String string = this.volumeLabel;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            FatDirectoryEntry fatDirectoryEntry = FatDirectoryEntry.Companion.createVolumeLabel(string);
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            fatDirectoryEntry.serialize(byteBuffer);
        }
        List<FatLfnDirectoryEntry> list2 = this.entries;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        for (FatLfnDirectoryEntry entry : list2) {
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            entry.serialize(byteBuffer);
        }
        if (totalBytes % (long)this.bootSector.getBytesPerCluster() != 0L || totalBytes == 0L) {
            buffer.put(new byte[buffer.remaining()]);
        }
        buffer.flip();
        ClusterChain clusterChain3 = this.chain;
        if (clusterChain3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
        }
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        clusterChain3.write$libaums_release(0L, byteBuffer);
    }

    @Override
    @NotNull
    public FatFile createFile(@NotNull String name) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = name;
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        Map<String, FatLfnDirectoryEntry> map = this.lfnMap;
        boolean bl = false;
        String string2 = string.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string3 = string2;
        if (map.containsKey(string3)) {
            throw (Throwable)new IOException("Item already exists!");
        }
        this.init();
        ShortName shortName = ShortNameGenerator.INSTANCE.generateShortName(name, (Collection<ShortName>)this.shortNameMap.keySet());
        FatLfnDirectoryEntry entry = new FatLfnDirectoryEntry(name, shortName);
        long newStartCluster = this.fat.alloc$libaums_release(new Long[0], 1)[0];
        entry.setStartCluster(newStartCluster);
        Log.d((String)TAG, (String)("adding entry: " + entry + " with short name: " + shortName));
        this.addEntry(entry, entry.getActualEntry());
        this.write$libaums_release();
        FatFile file = new FatFile(this.blockDevice, this.fat, this.bootSector, entry, this);
        ((Map)this.fs.getFileCache$libaums_release()).put(file.getAbsolutePath(), file);
        return file;
    }

    @Override
    @NotNull
    public FatDirectory createDirectory(@NotNull String name) throws IOException {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = name;
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        Map<String, FatLfnDirectoryEntry> map = this.lfnMap;
        boolean bl = false;
        String string2 = string.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string3 = string2;
        if (map.containsKey(string3)) {
            throw (Throwable)new IOException("Item already exists!");
        }
        this.init();
        ShortName shortName = ShortNameGenerator.INSTANCE.generateShortName(name, (Collection<ShortName>)this.shortNameMap.keySet());
        FatLfnDirectoryEntry entry = new FatLfnDirectoryEntry(name, shortName);
        entry.setDirectory();
        long newStartCluster = this.fat.alloc$libaums_release(new Long[0], 1)[0];
        entry.setStartCluster(newStartCluster);
        Log.d((String)TAG, (String)("adding entry: " + entry + " with short name: " + shortName));
        this.addEntry(entry, entry.getActualEntry());
        this.write$libaums_release();
        FatDirectory result = new FatDirectory(this.fs, this.blockDevice, this.fat, this.bootSector, entry, this);
        result.hasBeenInited = true;
        result.entries = new ArrayList();
        FatLfnDirectoryEntry dotEntry = new FatLfnDirectoryEntry(null, new ShortName(".", ""));
        dotEntry.setDirectory();
        dotEntry.setStartCluster(newStartCluster);
        FatLfnDirectoryEntry.Companion.copyDateTime(entry, dotEntry);
        result.addEntry(dotEntry, dotEntry.getActualEntry());
        FatLfnDirectoryEntry dotDotEntry = new FatLfnDirectoryEntry(null, new ShortName("..", ""));
        dotDotEntry.setDirectory();
        if (this.isRoot()) {
            l = 0L;
        } else {
            FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
            if (fatLfnDirectoryEntry == null) {
                Intrinsics.throwNpe();
            }
            l = fatLfnDirectoryEntry.getStartCluster();
        }
        dotDotEntry.setStartCluster(l);
        FatLfnDirectoryEntry.Companion.copyDateTime(entry, dotDotEntry);
        result.addEntry(dotDotEntry, dotDotEntry.getActualEntry());
        result.write$libaums_release();
        ((Map)this.fs.getFileCache$libaums_release()).put(result.getAbsolutePath(), result);
        return result;
    }

    @Override
    public long createdAt() {
        boolean bl = !this.isRoot();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "root dir!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
        if (fatLfnDirectoryEntry == null) {
            Intrinsics.throwNpe();
        }
        return fatLfnDirectoryEntry.getActualEntry().getCreatedDateTime();
    }

    @Override
    public long lastModified() {
        boolean bl = !this.isRoot();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "root dir!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
        if (fatLfnDirectoryEntry == null) {
            Intrinsics.throwNpe();
        }
        return fatLfnDirectoryEntry.getActualEntry().getLastModifiedDateTime();
    }

    @Override
    public long lastAccessed() {
        boolean bl = !this.isRoot();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "root dir!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
        if (fatLfnDirectoryEntry == null) {
            Intrinsics.throwNpe();
        }
        return fatLfnDirectoryEntry.getActualEntry().getLastAccessedDateTime();
    }

    @Override
    @NotNull
    public String[] list() throws IOException {
        this.init();
        List<FatLfnDirectoryEntry> list = this.entries;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        ArrayList<String> list2 = new ArrayList<String>(list.size());
        List<FatLfnDirectoryEntry> list3 = this.entries;
        if (list3 == null) {
            Intrinsics.throwNpe();
        }
        for (FatLfnDirectoryEntry entry : list3) {
            String name = entry.getName$libaums_release();
            if (!(Intrinsics.areEqual((Object)name, (Object)".") ^ true) || !(Intrinsics.areEqual((Object)name, (Object)"..") ^ true)) continue;
            list2.add(name);
        }
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    @Override
    @NotNull
    public UsbFile[] listFiles() throws IOException {
        this.init();
        List<FatLfnDirectoryEntry> list = this.entries;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        ArrayList<UsbFile> list2 = new ArrayList<UsbFile>(list.size());
        List<FatLfnDirectoryEntry> list3 = this.entries;
        if (list3 == null) {
            Intrinsics.throwNpe();
        }
        for (FatLfnDirectoryEntry entry : list3) {
            UsbFile usbFile;
            String name = entry.getName$libaums_release();
            if (Intrinsics.areEqual((Object)name, (Object)".") || Intrinsics.areEqual((Object)name, (Object)"..")) continue;
            String entryAbsolutePath = this.isRoot() ? "/" + entry.getName$libaums_release() : this.getAbsolutePath() + "/" + entry.getName$libaums_release();
            if (this.fs.getFileCache$libaums_release().get(entryAbsolutePath) != null) {
                UsbFile usbFile2 = this.fs.getFileCache$libaums_release().get(entryAbsolutePath);
                if (usbFile2 == null) {
                    Intrinsics.throwNpe();
                }
                usbFile = usbFile2;
            } else {
                usbFile = entry.isDirectory() ? (UsbFile)new FatDirectory(this.fs, this.blockDevice, this.fat, this.bootSector, entry, this) : (UsbFile)new FatFile(this.blockDevice, this.fat, this.bootSector, entry, this);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)usbFile, (String)"when {\n                f\u2026ntry, this)\n            }");
            UsbFile file = usbFile;
            ((Map)this.fs.getFileCache$libaums_release()).put(entryAbsolutePath, file);
            list2.add(file);
        }
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsbFile[] usbFileArray = thisCollection$iv.toArray(new UsbFile[0]);
        if (usbFileArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return usbFileArray;
    }

    @Override
    public void read(long offset, @NotNull ByteBuffer destination) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        throw (Throwable)new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void write(long offset, @NotNull ByteBuffer source) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        throw (Throwable)new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void flush() throws IOException {
        throw (Throwable)new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void close() throws IOException {
        throw (Throwable)new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void moveTo(@NotNull UsbFile destination) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = !this.isRoot();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "cannot move root dir!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = destination.isDirectory();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "destination cannot be a file!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = destination instanceof FatDirectory;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "cannot move between different filesystems!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map<String, FatLfnDirectoryEntry> map = ((FatDirectory)destination).lfnMap;
        FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
        if (fatLfnDirectoryEntry == null) {
            Intrinsics.throwNpe();
        }
        String string = fatLfnDirectoryEntry.getName$libaums_release();
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        Map<String, FatLfnDirectoryEntry> map2 = map;
        bl3 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string4 = string3;
        if (map2.containsKey(string4)) {
            throw (Throwable)new IOException("item already exists in destination!");
        }
        this.init();
        ((FatDirectory)destination).init();
        FatDirectory fatDirectory = this.getParent();
        if (fatDirectory == null) {
            Intrinsics.throwNpe();
        }
        fatDirectory.removeEntry$libaums_release(this.entry);
        FatDirectory fatDirectory2 = (FatDirectory)destination;
        FatLfnDirectoryEntry fatLfnDirectoryEntry2 = this.entry;
        if (fatLfnDirectoryEntry2 == null) {
            Intrinsics.throwNpe();
        }
        FatLfnDirectoryEntry fatLfnDirectoryEntry3 = this.entry;
        if (fatLfnDirectoryEntry3 == null) {
            Intrinsics.throwNpe();
        }
        fatDirectory2.addEntry(fatLfnDirectoryEntry2, fatLfnDirectoryEntry3.getActualEntry());
        FatDirectory fatDirectory3 = this.getParent();
        if (fatDirectory3 == null) {
            Intrinsics.throwNpe();
        }
        fatDirectory3.write$libaums_release();
        ((FatDirectory)destination).write$libaums_release();
        this.setParent((FatDirectory)destination);
    }

    public final void move$libaums_release(@NotNull FatLfnDirectoryEntry entry, @NotNull UsbFile destination) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = destination.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "destination cannot be a file!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = destination instanceof FatDirectory;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "cannot move between different filesystems!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map<String, FatLfnDirectoryEntry> map = ((FatDirectory)destination).lfnMap;
        String string = entry.getName$libaums_release();
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        Map<String, FatLfnDirectoryEntry> map2 = map;
        bl3 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string4 = string3;
        if (map2.containsKey(string4)) {
            throw (Throwable)new IOException("item already exists in destination!");
        }
        this.init();
        ((FatDirectory)destination).init();
        this.removeEntry$libaums_release(entry);
        ((FatDirectory)destination).addEntry(entry, entry.getActualEntry());
        this.write$libaums_release();
        ((FatDirectory)destination).write$libaums_release();
    }

    @Override
    public void delete() throws IOException {
        UsbFile[] subElements;
        boolean bl = !this.isRoot();
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Root dir cannot be deleted!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.init();
        for (UsbFile file : subElements = this.listFiles()) {
            file.delete();
        }
        FatDirectory fatDirectory = this.getParent();
        if (fatDirectory == null) {
            Intrinsics.throwNpe();
        }
        fatDirectory.removeEntry$libaums_release(this.entry);
        FatDirectory fatDirectory2 = this.getParent();
        if (fatDirectory2 == null) {
            Intrinsics.throwNpe();
        }
        fatDirectory2.write$libaums_release();
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
        }
        clusterChain.setLength$libaums_release(0L);
    }

    @Override
    @Nullable
    public FatDirectory getParent() {
        return this.parent;
    }

    public void setParent(@Nullable FatDirectory fatDirectory) {
        this.parent = fatDirectory;
    }

    public FatDirectory(@NotNull Fat32FileSystem fs, @NotNull BlockDeviceDriver blockDevice, @NotNull FAT fat, @NotNull Fat32BootSector bootSector, @Nullable FatLfnDirectoryEntry entry, @Nullable FatDirectory parent) {
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkParameterIsNotNull((Object)fat, (String)"fat");
        Intrinsics.checkParameterIsNotNull((Object)bootSector, (String)"bootSector");
        this.fs = fs;
        this.blockDevice = blockDevice;
        this.fat = fat;
        this.bootSector = bootSector;
        this.entry = entry;
        this.parent = parent;
        this.lfnMap = new HashMap();
        this.shortNameMap = new HashMap();
    }

    static {
        Companion = new Companion(null);
        String string = FatDirectory.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FatDirectory::class.java.simpleName");
        TAG = string;
    }

    public static final /* synthetic */ ClusterChain access$getChain$p(FatDirectory $this) {
        ClusterChain clusterChain = $this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
        }
        return clusterChain;
    }

    @JvmStatic
    @NotNull
    public static final FatDirectory readRoot$libaums_release(@NotNull Fat32FileSystem fs, @NotNull BlockDeviceDriver blockDevice, @NotNull FAT fat, @NotNull Fat32BootSector bootSector) throws IOException {
        return Companion.readRoot$libaums_release(fs, blockDevice, fat, bootSector);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/FatDirectory$Companion;", "", "()V", "TAG", "", "readRoot", "Lcom/github/mjdev/libaums/fs/fat32/FatDirectory;", "fs", "Lcom/github/mjdev/libaums/fs/fat32/Fat32FileSystem;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "fat", "Lcom/github/mjdev/libaums/fs/fat32/FAT;", "bootSector", "Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;", "readRoot$libaums_release", "libaums_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final FatDirectory readRoot$libaums_release(@NotNull Fat32FileSystem fs, @NotNull BlockDeviceDriver blockDevice, @NotNull FAT fat, @NotNull Fat32BootSector bootSector) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
            Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
            Intrinsics.checkParameterIsNotNull((Object)fat, (String)"fat");
            Intrinsics.checkParameterIsNotNull((Object)bootSector, (String)"bootSector");
            FatDirectory result = new FatDirectory(fs, blockDevice, fat, bootSector, null, null);
            result.chain = new ClusterChain(bootSector.getRootDirStartCluster(), blockDevice, fat, bootSector);
            result.init();
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

