/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import com.github.mjdev.libaums.fs.UsbFile;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/mjdev/libaums/fs/UsbFileOutputStream;", "Ljava/io/OutputStream;", "file", "Lcom/github/mjdev/libaums/fs/UsbFile;", "append", "", "(Lcom/github/mjdev/libaums/fs/UsbFile;Z)V", "currentByteOffset", "", "close", "", "flush", "write", "buffer", "", "offset", "", "count", "oneByte", "libaums_release"})
public final class UsbFileOutputStream
extends OutputStream {
    private long currentByteOffset;
    private final UsbFile file;

    @Override
    public void write(int oneByte) throws IOException {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.wrap(new byte[]{(byte)oneByte});
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"byteBuffer");
        this.file.write(this.currentByteOffset, byteBuffer2);
        long l = this.currentByteOffset;
        this.currentByteOffset = l + 1L;
    }

    @Override
    public void close() throws IOException {
        this.file.setLength(this.currentByteOffset);
        this.file.close();
    }

    @Override
    public void flush() throws IOException {
        this.file.flush();
    }

    @Override
    public void write(@NotNull byte[] buffer) throws IOException {
        ByteBuffer byteBuffer;
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.wrap(buffer);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"byteBuffer");
        this.file.write(this.currentByteOffset, byteBuffer2);
        this.currentByteOffset += (long)buffer.length;
    }

    @Override
    public void write(@NotNull byte[] buffer, int offset, int count) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.position(offset);
        byteBuffer.limit(count + offset);
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"byteBuffer");
        this.file.write(this.currentByteOffset, byteBuffer2);
        this.currentByteOffset += (long)count;
    }

    @JvmOverloads
    public UsbFileOutputStream(@NotNull UsbFile file, boolean append) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        if (this.file.isDirectory()) {
            throw (Throwable)new UnsupportedOperationException("UsbFileOutputStream cannot be created on directory!");
        }
        if (append) {
            this.currentByteOffset = this.file.getLength();
        }
    }

    public /* synthetic */ UsbFileOutputStream(UsbFile usbFile, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(usbFile, bl);
    }

    @JvmOverloads
    public UsbFileOutputStream(@NotNull UsbFile file) {
        this(file, false, 2, null);
    }
}

