/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.FileSystemCreator;
import com.github.mjdev.libaums.fs.fat32.Fat32FileSystemCreator;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/github/mjdev/libaums/fs/FileSystemFactory;", "", "()V", "fileSystems", "Ljava/util/ArrayList;", "Lcom/github/mjdev/libaums/fs/FileSystemCreator;", "timeZone", "Ljava/util/TimeZone;", "kotlin.jvm.PlatformType", "timeZone$annotations", "getTimeZone", "()Ljava/util/TimeZone;", "setTimeZone", "(Ljava/util/TimeZone;)V", "createFileSystem", "Lcom/github/mjdev/libaums/fs/FileSystem;", "entry", "Lcom/github/mjdev/libaums/partition/PartitionTableEntry;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "registerFileSystem", "", "creator", "UnsupportedFileSystemException", "libaums_release"})
public final class FileSystemFactory {
    private static final ArrayList<FileSystemCreator> fileSystems;
    private static TimeZone timeZone;
    public static final FileSystemFactory INSTANCE;

    @JvmStatic
    public static /* synthetic */ void timeZone$annotations() {
    }

    public static final TimeZone getTimeZone() {
        return timeZone;
    }

    public static final void setTimeZone(TimeZone timeZone) {
        FileSystemFactory.timeZone = timeZone;
    }

    @NotNull
    public final FileSystem createFileSystem(@NotNull PartitionTableEntry entry, @NotNull BlockDeviceDriver blockDevice) throws IOException, UnsupportedFileSystemException {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
        for (FileSystemCreator creator : fileSystems) {
            FileSystem fs = creator.read(entry, blockDevice);
            if (fs == null) continue;
            return fs;
        }
        throw (Throwable)new UnsupportedFileSystemException();
    }

    public final synchronized void registerFileSystem(@NotNull FileSystemCreator creator) {
        Intrinsics.checkParameterIsNotNull((Object)creator, (String)"creator");
        fileSystems.add(creator);
    }

    private FileSystemFactory() {
    }

    static {
        FileSystemFactory fileSystemFactory;
        INSTANCE = fileSystemFactory = new FileSystemFactory();
        fileSystems = new ArrayList();
        timeZone = TimeZone.getDefault();
        fileSystemFactory.registerFileSystem(new Fat32FileSystemCreator());
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/github/mjdev/libaums/fs/FileSystemFactory$UnsupportedFileSystemException;", "Ljava/io/IOException;", "()V", "libaums_release"})
    public static final class UnsupportedFileSystemException
    extends IOException {
    }
}

