/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.annotation.TargetApi;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import com.github.mjdev.libaums.ErrNo;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/mjdev/libaums/usb/JellyBeanMr2Communication;", "Lcom/github/mjdev/libaums/usb/UsbCommunication;", "deviceConnection", "Landroid/hardware/usb/UsbDeviceConnection;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "(Landroid/hardware/usb/UsbDeviceConnection;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "bulkInTransfer", "", "dest", "Ljava/nio/ByteBuffer;", "bulkOutTransfer", "src", "libaums_release"})
@TargetApi(value=18)
public final class JellyBeanMr2Communication
implements UsbCommunication {
    private final UsbDeviceConnection deviceConnection;
    private final UsbEndpoint outEndpoint;
    private final UsbEndpoint inEndpoint;

    @Override
    public int bulkOutTransfer(@NotNull ByteBuffer src) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        int result = this.deviceConnection.bulkTransfer(this.outEndpoint, src.array(), src.position(), src.remaining(), 5000);
        if (result == -1) {
            throw (Throwable)new IOException("Could not write to device, result == -1 errno " + ErrNo.INSTANCE.getErrno() + " " + ErrNo.INSTANCE.getErrstr());
        }
        src.position(src.position() + result);
        return result;
    }

    @Override
    public int bulkInTransfer(@NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        int result = this.deviceConnection.bulkTransfer(this.inEndpoint, dest.array(), dest.position(), dest.remaining(), 5000);
        if (result == -1) {
            throw (Throwable)new IOException("Could not read from device, result == -1 errno " + ErrNo.INSTANCE.getErrno() + " " + ErrNo.INSTANCE.getErrstr());
        }
        dest.position(dest.position() + result);
        return result;
    }

    public JellyBeanMr2Communication(@NotNull UsbDeviceConnection deviceConnection, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        Intrinsics.checkParameterIsNotNull((Object)deviceConnection, (String)"deviceConnection");
        Intrinsics.checkParameterIsNotNull((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkParameterIsNotNull((Object)inEndpoint, (String)"inEndpoint");
        this.deviceConnection = deviceConnection;
        this.outEndpoint = outEndpoint;
        this.inEndpoint = inEndpoint;
    }
}

