/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition.fs;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/github/mjdev/libaums/partition/fs/FileSystemPartitionTable;", "Lcom/github/mjdev/libaums/partition/PartitionTable;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "fs", "Lcom/github/mjdev/libaums/fs/FileSystem;", "(Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;Lcom/github/mjdev/libaums/fs/FileSystem;)V", "entries", "", "Lcom/github/mjdev/libaums/partition/PartitionTableEntry;", "getEntries$libaums_release", "()Ljava/util/List;", "setEntries$libaums_release", "(Ljava/util/List;)V", "partitionTableEntries", "", "getPartitionTableEntries", "size", "", "getSize", "()I", "Companion", "libaums_release"})
public final class FileSystemPartitionTable
implements PartitionTable {
    @NotNull
    private List<PartitionTableEntry> entries;
    private static final String TAG;
    public static final Companion Companion;

    @NotNull
    public final List<PartitionTableEntry> getEntries$libaums_release() {
        return this.entries;
    }

    public final void setEntries$libaums_release(@NotNull List<PartitionTableEntry> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.entries = list;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    @NotNull
    public List<PartitionTableEntry> getPartitionTableEntries() {
        return this.entries;
    }

    public FileSystemPartitionTable(@NotNull BlockDeviceDriver blockDevice, @NotNull FileSystem fs) {
        Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        this.entries = new ArrayList();
        Log.i((String)TAG, (String)"Found a device without partition table, yay!");
        int totalNumberOfSectors = (int)fs.getCapacity() / blockDevice.getBlockSize();
        if (fs.getCapacity() % (long)blockDevice.getBlockSize() != 0L) {
            Log.w((String)TAG, (String)"fs capacity is not multiple of block size");
        }
        this.entries.add(new PartitionTableEntry(fs.getType(), 0, totalNumberOfSectors));
    }

    static {
        Companion = new Companion(null);
        TAG = FileSystemPartitionTable.class.getSimpleName();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/mjdev/libaums/partition/fs/FileSystemPartitionTable$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

