/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FsInfoStructure;
import com.github.mjdev.libaums.util.LRUCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;

public class FAT {
    private static final String TAG = FAT.class.getSimpleName();
    private static final int FAT32_EOF_CLUSTER = 0xFFFFFF8;
    private BlockDeviceDriver blockDevice;
    private long[] fatOffset;
    private int[] fatNumbers;
    private FsInfoStructure fsInfoStructure;
    private LRUCache<Long, Long[]> cache = new LRUCache(64);

    FAT(BlockDeviceDriver blockDevice, Fat32BootSector bootSector, FsInfoStructure fsInfoStructure) {
        this.blockDevice = blockDevice;
        this.fsInfoStructure = fsInfoStructure;
        if (!bootSector.isFatMirrored()) {
            byte fatNumber = bootSector.getValidFat();
            this.fatNumbers = new int[]{fatNumber};
            Log.i((String)TAG, (String)("fat is not mirrored, fat " + fatNumber + " is valid"));
        } else {
            int fatCount = bootSector.getFatCount();
            this.fatNumbers = new int[fatCount];
            for (int i = 0; i < fatCount; ++i) {
                this.fatNumbers[i] = i;
            }
            Log.i((String)TAG, (String)("fat is mirrored, fat count: " + fatCount));
        }
        this.fatOffset = new long[this.fatNumbers.length];
        for (int i = 0; i < this.fatOffset.length; ++i) {
            this.fatOffset[i] = bootSector.getFatOffset(this.fatNumbers[i]);
        }
    }

    Long[] getChain(long startCluster) throws IOException {
        long offsetInBlock;
        if (startCluster == 0L) {
            return new Long[0];
        }
        Long[] cachedChain = (Long[])this.cache.get(startCluster);
        if (cachedChain != null) {
            return cachedChain;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        int bufferSize = this.blockDevice.getBlockSize() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long currentCluster = startCluster;
        long lastOffset = -1L;
        do {
            result.add(currentCluster);
            long offset = (this.fatOffset[0] + currentCluster * 4L) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * 4L) % (long)bufferSize;
            if (lastOffset == offset) continue;
            buffer.clear();
            this.blockDevice.read(offset, buffer);
            lastOffset = offset;
        } while ((currentCluster = (long)(buffer.getInt((int)offsetInBlock) & 0xFFFFFFF)) < 0xFFFFFF8L);
        Long[] arr = result.toArray(new Long[0]);
        this.cache.put(startCluster, arr);
        return arr;
    }

    Long[] alloc(Long[] chain, int numberOfClusters) throws IOException {
        long offsetInBlock;
        long offset;
        int originalNumberOfClusters = numberOfClusters;
        ArrayList<Long> result = new ArrayList<Long>(chain.length + numberOfClusters);
        result.addAll(Arrays.asList(chain));
        int bufferSize = this.blockDevice.getBlockSize() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long cluster = chain.length != 0 ? chain[chain.length - 1] : -1L;
        long lastAllocated = this.fsInfoStructure.getLastAllocatedClusterHint();
        if (lastAllocated == (long)FsInfoStructure.INVALID_VALUE) {
            lastAllocated = 2L;
        }
        long currentCluster = lastAllocated;
        long lastOffset = -1L;
        while (numberOfClusters > 0) {
            offset = (this.fatOffset[0] + ++currentCluster * 4L) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * 4L) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            if (buffer.getInt((int)offsetInBlock) != 0) continue;
            result.add(currentCluster);
            --numberOfClusters;
        }
        if (cluster != -1L) {
            offset = (this.fatOffset[0] + cluster * 4L) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + cluster * 4L) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, (int)((Long)result.get(chain.length)).longValue());
        }
        for (int i = chain.length; i < result.size() - 1; ++i) {
            currentCluster = (Long)result.get(i);
            offset = (this.fatOffset[0] + currentCluster * 4L) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * 4L) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                this.blockDevice.write(lastOffset, buffer);
                buffer.clear();
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, (int)((Long)result.get(i + 1)).longValue());
        }
        currentCluster = (Long)result.get(result.size() - 1);
        offset = (this.fatOffset[0] + currentCluster * 4L) / (long)bufferSize * (long)bufferSize;
        offsetInBlock = (this.fatOffset[0] + currentCluster * 4L) % (long)bufferSize;
        if (lastOffset != offset) {
            buffer.clear();
            this.blockDevice.write(lastOffset, buffer);
            buffer.clear();
            this.blockDevice.read(offset, buffer);
            lastOffset = offset;
        }
        buffer.putInt((int)offsetInBlock, 0xFFFFFF8);
        buffer.clear();
        this.blockDevice.write(offset, buffer);
        this.fsInfoStructure.setLastAllocatedClusterHint(currentCluster);
        this.fsInfoStructure.decreaseClusterCount(originalNumberOfClusters);
        this.fsInfoStructure.write();
        Log.i((String)TAG, (String)"allocating clusters finished");
        Long[] arr = result.toArray(new Long[0]);
        this.cache.put(arr[0], arr);
        return arr;
    }

    Long[] free(Long[] chain, int numberOfClusters) throws IOException {
        long offsetInBlock;
        long offset;
        long currentCluster;
        int offsetInChain = chain.length - numberOfClusters;
        int bufferSize = this.blockDevice.getBlockSize() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (offsetInChain < 0) {
            throw new IllegalStateException("trying to remove more clusters in chain than currently exist!");
        }
        long lastOffset = -1L;
        for (int i = offsetInChain; i < chain.length; ++i) {
            currentCluster = chain[i];
            offset = (this.fatOffset[0] + currentCluster * 4L) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * 4L) % (long)bufferSize;
            if (lastOffset != offset) {
                if (lastOffset != -1L) {
                    buffer.clear();
                    this.blockDevice.write(lastOffset, buffer);
                }
                buffer.clear();
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, 0);
        }
        if (offsetInChain > 0) {
            currentCluster = chain[offsetInChain - 1];
            offset = (this.fatOffset[0] + currentCluster * 4L) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * 4L) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                this.blockDevice.write(lastOffset, buffer);
                buffer.clear();
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, 0xFFFFFF8);
            buffer.clear();
            this.blockDevice.write(offset, buffer);
        } else {
            buffer.clear();
            this.blockDevice.write(lastOffset, buffer);
        }
        Log.i((String)TAG, (String)("freed " + numberOfClusters + " clusters"));
        this.fsInfoStructure.decreaseClusterCount(-numberOfClusters);
        this.fsInfoStructure.write();
        Long[] arr = Arrays.copyOfRange(chain, 0, offsetInChain);
        if (arr.length > 0) {
            this.cache.put(arr[0], arr);
        }
        return arr;
    }
}

